import type { TabsProps } from 'antd'

import { Tabs } from 'antd'

import Media from './media'
import Slot from './slot'
import store from './store'

const tabsItems: TabsProps['items'] = [
  {
    key: 'media',
    label: '媒体',
    children: <Media />,
  },
  {
    key: 'slot',
    label: '广告位',
    children: <Slot />,
  },
]

const MediaManage = observer(() => {
  const { setTag, currentTag } = store
  const onChange = (key: string) => {
    setTag(key)
  }
  return (
    <Space direction='vertical' style={{ display: 'flex' }} size='middle'>
      <Tabs activeKey={currentTag} items={tabsItems} onChange={onChange} />
    </Space>
  )
})

export default MediaManage
