export const statusColorMap: Record<string, string> = {
  ['待审核']: 'brown',
  ['审核通过']: 'green',
  ['审核拒绝']: 'red',
}
// 策略类型
export enum SLOT_TYPE {
  /** 开屏 */
  OPEN_SCREEN = 1,
  /** 信息流 */
  INFO = 2,
  /** 插屏 */
  INSERT_SCREEN = 3,
  /** 激励视频 */
  MOTIVATE = 4,
}

export const SLOT_TYPE_TEXT = {
  [SLOT_TYPE.OPEN_SCREEN]: '开屏',
  [SLOT_TYPE.INFO]: '信息流',
  [SLOT_TYPE.INSERT_SCREEN]: '插屏',
  [SLOT_TYPE.MOTIVATE]: '激励视频',
}

export const SLOT_TYPE_OPTIONS = [
  {
    label: SLOT_TYPE_TEXT[SLOT_TYPE.OPEN_SCREEN],
    value: SLOT_TYPE.OPEN_SCREEN,
  },
  {
    label: SLOT_TYPE_TEXT[SLOT_TYPE.INFO],
    value: SLOT_TYPE.INFO,
  },
  {
    label: SLOT_TYPE_TEXT[SLOT_TYPE.INSERT_SCREEN],
    value: SLOT_TYPE.INSERT_SCREEN,
  },
  {
    label: SLOT_TYPE_TEXT[SLOT_TYPE.MOTIVATE],
    value: SLOT_TYPE.MOTIVATE,
  },
]

export const enum MATERIAL_STYLE {
  /** 竖图 */
  VERTICAL_PHOTO = 1,
  /** 横图 */
  HORIZONTAL_PHOTO = 2,
  /** 竖视频 */
  VERTICAL_VIDEO = 3,
  /** 横视频 */
  HORIZONTAL_VIDEO = 4,
}

export const MATERIAL_STYLE_TEXT = {
  [MATERIAL_STYLE.VERTICAL_PHOTO]: '竖图',
  [MATERIAL_STYLE.HORIZONTAL_PHOTO]: '横图',
  [MATERIAL_STYLE.VERTICAL_VIDEO]: '竖视频',
  [MATERIAL_STYLE.HORIZONTAL_VIDEO]: '横视频',
}

export const MATERIAL_STYLE_OPTIONS = [
  {
    label: MATERIAL_STYLE_TEXT[MATERIAL_STYLE.VERTICAL_PHOTO],
    value: MATERIAL_STYLE.VERTICAL_PHOTO,
  },
  {
    label: MATERIAL_STYLE_TEXT[MATERIAL_STYLE.HORIZONTAL_PHOTO],
    value: MATERIAL_STYLE.HORIZONTAL_PHOTO,
  },
  {
    label: MATERIAL_STYLE_TEXT[MATERIAL_STYLE.VERTICAL_VIDEO],
    value: MATERIAL_STYLE.VERTICAL_VIDEO,
  },
  {
    label: MATERIAL_STYLE_TEXT[MATERIAL_STYLE.HORIZONTAL_VIDEO],
    value: MATERIAL_STYLE.HORIZONTAL_VIDEO,
  },
]

export const enum PARAMS_TYPE {
  /** 媒体 */
  MEDIA = 1,
  /** DSP */
  DSP = 2,
}
