class MediaAccountStore {
  isModalOpen = false

  searchParams: mediaSearchP = {
    mediaId: '',
    mediaName: '',
    AE: '',
    PE: '',
    pageSize: 15,
    currentPage: 1,
  }
  mediaAccount: mediaAccount | undefined = {
    mediaId: '',
    mediaName: '',
    cName: '',
    pe: '',
    phone: '',
    email: '',
    account: '',
    pic1: '',
    pic2: '',
  }
  constructor() {
    makeAutoObservable(this) // 自动推断类型
  }

  getModalOpen = () => {
    return this.isModalOpen
  }

  setModalOpen = (value: boolean) => {
    this.isModalOpen = value
  }

  setSearchParams = (value: mediaSearchP) => {
    this.searchParams = { ...this.searchParams, ...value }
  }

  setMediaAccount = (value: mediaAccount | undefined) => {
    this.mediaAccount = value ? { ...value } : undefined
  }

  addMediaAccountFc = (params: mediaAccount) => {
    console.log('params', params)
    const res = addMediaAccountAPI(params)
    console.log(res)
  }

  getMediaAccountFc = (id: number | string) => {
    const res = getMediaAccountAPI(id)
    console.log(res)
    this.setMediaAccount({
      mediaId: 'text',
      mediaName: 'text',
      cName: 'text',
      pe: 'text',
      phone: 'text',
      email: 'text',
      account: 'text',
      pic1: 'http://yun.dui88.com/-rr2kxnz9cm-e1lpywd8t.png',
      pic2: 'http://yun.dui88.com/-rr2kxnz9cm-e1lpywd8t.png',
    })
  }

  changeAE = (id: string | number, value: number) => {
    changeAEByIdAPI({ mediaId: id, AE: value })
  }

  changeAEList = (id: string | number, name: string[]) => {
    changeAEListByIdAPI({ mediaId: id, AEList: name })
  }

  changePE = (id: string | number, name: string) => {
    changePEByIdAPI({ mediaId: id, PE: name })
  }

  changeStatue = (id: string | number, statue: boolean) => {
    changeStatueByIdAPI({ mediaId: id, statue })
  }
}

export const mediaAccountStore = new MediaAccountStore()
