import { Dayjs } from 'dayjs'
/**
 * 媒体列表
 */
export interface MediaInfo {
  /** 媒体id */
  id: number
  /** 流量开关 */
  status: number
  /** 媒体名称 */
  mediaName: string
  /** 曝光 */
  exposePv: number
  /** 点击 */
  clickPv: number
  /** 点击率 */
  clickRate: number
  /** 消耗 */
  consume: number
  /** cpc */
  cpc: number
  auditStatus: number
  /** 审核状态 */
  auditStatusDesc: string
}

export type MediaInfoList = List<MediaInfo>
/**
 * 查询参数
 */
export interface QueryMediaParams extends paginationType {
  startDate?: string
  endDate?: string
  /** 媒体名称 */
  mediaName?: string
  /** 媒体id */
  id?: number
  date?: Dayjs[]
}
