const NodeDocker = require('@tuia/node-docker')
const Koa = require('koa')
const logger = require('koa-logger')
const onerror = require('koa-onerror')
const Router = require('koa-router')
const koaStatic = require('koa-static')
const path = require('path')
const Eurekaclient = require('@tuia/eureka-client-ts').default

const app = new Koa()
const router = new Router()

// error handler
onerror(app)

app.use(
  logger((str, args) => {
    !str.includes('/monitor/check') && console.log(str)
  })
)
app.use(koaStatic(path.join(__dirname, './dist')))

// 用于中台确认应用是否运行正常
router.get('/monitor/check', function (ctx, next) {
  ctx.body = 'ok'
})
app.use(router.routes())

const dockerApp = new NodeDocker({
  app,
  appType: 'koa',
  port: 3000,
})

dockerApp.startServer().then(async () => {
  const client = new Eurekaclient({
    port: 3000,
    appName: '<app-name>',
    services: [
      // 需要通信的其他应用名
    ],
  })

  await client.start()
  global.eureka = client
})

// 进程结束主动通知Eureka取消注册
let isShuttingDown = false
async function deregisterEureka() {
  if (global.eureka) {
    console.log('Deregistering from Eureka...')
    await new Promise((resolve) => {
      global.eureka.eureka.deregister(() => {
        console.log('Deregistered from Eureka...')
        resolve()
      })
    })
  }
}
async function gracefulShutdown() {
  if (isShuttingDown) return
  isShuttingDown = true
  console.log('Exitting...')
  await deregisterEureka()
  process.exit(0)
}
;['exit', 'SIGINT', 'SIGTERM'].forEach((event) => {
  process.on(event, gracefulShutdown)
})
