import { Equation } from "./Equation";
import { Body } from "../objects/Body";


export class RotationalVelocityEquation extends Equation {

    ratio: number;
    /**
     * Syncs rotational velocity of two bodies, or sets a relative velocity (motor).
     *
     * @class RotationalVelocityEquation
     * @constructor
     * @extends Equation
     * @param {Body} bodyA
     * @param {Body} bodyB
     */
    constructor(bodyA: Body, bodyB: Body) {
        super(bodyA, bodyB, -Number.MAX_VALUE, Number.MAX_VALUE);
        this.relativeVelocity = 1;
        this.ratio = 1;
    }

    computeB(a, b, h) {
        var G = this.G;
        G[2] = -1;
        G[5] = this.ratio;

        var GiMf = this.computeGiMf();
        var GW = this.computeGW();
        var B = - GW * b - h * GiMf;

        return B;
    };
}
