import Texture from "../texture/Texture";
import { Event } from "../events/Event";
import Sprite from "../display/Sprite";
import { Container } from "../display";

/**
 * 直接通过替换texture替换图片的动画帧
 * 暂时这些动画帧只播放一次，所以简化,要循环时再修改
 * 默认按时间间隔播放
 * 图片都以素材为中心为原点
 */
export class FrameAni extends Container {
    private showImage: Sprite
    /**
     * 所有的纹理
     */
    private texturesAll: Texture[];
    /**
     * 从0开始 锁步会跳帧
     * 每一帧就是一张图片，从0开始
     */
    private currentFrame: number;
    /**
     * 所有帧数
     */
    get totalFrames(): number {
        return this.texturesAll.length
    };
    /**
     * 是否运行中
     */
    private isPlay: boolean;
    /**
     * 循环次数
     */
    private loop: number = 1;
    /**
     * 开始时间
     */
    private startTime: number
    /**
     * 所有时间,播完所用时间
     */
    private allTime: number
    /**
     * 播放完的回调
     */
    private callback: Function;
    /**
     * 每秒的帧数，默认30帧
     */
    private _frameRate: number;
    get frameRate() {
        return this._frameRate
    }
    set frameRate(value: number) {
        if (value == this._frameRate) return
        this._frameRate = value;
        this.allTime = this.texturesAll.length / this._frameRate * 1000;
    }
    /**
     * 
     * @param texturesAll 所有的资源数组
     */
    constructor(texturesAll: Texture[]) {
        super()
        this.showImage = new Sprite();
        this.showImage.anchorTexture.set(0.5, 0.5);
        this.addChild(this.showImage);
        this.texturesAll = texturesAll;
        this.changeTexture(0);
        this.currentFrame = 0;
        this.addEventListener(Event.ENTER_FRAME, this.onEnterFrame, this)
        this.frameRate = 30;
    }
    //需要做锁步
    private count = 0;
    onEnterFrame() {
        if (!this.isPlay) {
            // this.count = 0
            return
        }
        // this.count++;
        // if (this.count % 2 == 0) {
        //     this.currentFrame++;
        //     if (this.currentFrame == this.totalFrames/*-1*/) {
        //         this.currentFrame = 0;
        //         this.isPlay = false
        //         this.callback && this.callback();
        //     }
        //     this.texture = RES.getRes(this.sourceAll[this.currentFrame])
        //     this.x = -this.texture.textureWidth / 2;
        //     this.y = -this.texture.textureHeight / 2;
        // }
        var dataNow = Date.now();
        var deltaTime = dataNow - this.startTime;
        var scale = deltaTime / this.allTime;
        if (scale >= 1) {
            this.loop--;
            if (this.loop == 0) {
                this.isPlay = false
                this.callback && this.callback();
            } else {
                this.startTime = Date.now()
                this.currentFrame = 0;
                this.changeTexture(this.currentFrame);
            }
        } else {
            this.currentFrame = (scale * this.texturesAll.length) >> 0;
            this.changeTexture(this.currentFrame);
        }
    }
    /**
     * 从0开始播放
     */
    play(loop: number = 1, callback?: Function) {
        this.startTime = Date.now();
        this.isPlay = true;
        this.currentFrame = 0;
        this.changeTexture(0);
        this.loop = loop;
        this.callback = callback;
    }
    /**
     * 重置为frame，不播放
     */
    reset(frame: number = 0) {
        this.isPlay = false;
        this.currentFrame = frame;
        this.changeTexture(frame);
    }
    /**
     * 改texture和居中
     * @param index 
     */
    private changeTexture(index: number) {
        //考虑空帧的情况
        if (this.texturesAll[index]) {
            this.showImage.texture = this.texturesAll[index];
            // this.showImage.x = -this.texturesAll[index].width / 2;
            // this.showImage.y = -this.texturesAll[index].height / 2;
        } else {
            this.showImage.texture = null;
        }

    }
}