import { Rectangle } from '../../engine/2d/math/Rectangle';

import { Tool } from "../Tools";
import { Button } from "../../engine/2d/ui/Button";
import { MouseEvent } from "../../engine/2d/events/MouseEvent";
import { Panel } from "../../module/views/Panel";
import { RES } from "../../module/RES";
import { Sprite, Container } from "../../engine/2d/display";
import { Graphics } from '../../engine/2d/graphics';
import { Light } from '../common/Light';
import { BitmapText } from '../../engine/2d/text';
import { TEXT_ALIGN } from '../../engine/2d/const';

const foodData: {
    [key: number]: { name: string, des: string }
} = {
    8: { name: "爆浆麻薯150g*2袋", des: "" },
    16: { name: "面筋卷120g*2袋", des: "" },
    32: { name: "岩焗乳酪吐司500g", des: "" },
    64: { name: "鱼豆腐170g", des: "" },
    128: { name: "猪肉脯200g", des: "解锁后可在首页领取奖励哦~" },
    256: { name: "卤藕168g*2袋", des: "解锁后可在首页领取奖励哦~" },
    512: { name: "手撕面包1050g", des: "解锁后可在首页领取奖励哦~" },
    1024: { name: "枣夹核桃700g", des: "解锁后可在首页领取奖励哦~" },
    2048: { name: "甜辣鸭脖190g", des: "解锁后可在首页领取奖励哦~" },
}
/**
 * 解锁弹框
 */
export class UnlockPanel extends Panel {
    get groupNames() { return ["unlockPanel"] }

    closeBtn: Button;
    data: {
        grade: number
    }
    initUi() {
        //加光
        this.addChild(new Light()).position.set(375, 735);
        //背景
        this.addChild(Tool.addSprite("unlockPanelBg.png"));
        //关闭按钮
        this.closeBtn = new Button(RES.getRes("comCloseBtn.png"));
        this.closeBtn.position.set(614, 460);
        this.addChild(this.closeBtn);
        //继续游戏
        this.addChild(new Button(RES.getRes("jixuyouxi.png")))
            .once(MouseEvent.CLICK, this.onClick_closeBtn, this)
            .position.set((750 - 341) / 2, 978)
        //标题文案
        // this.addChild(new Title(this.data.grade))
        //奖品图片  246；
        this.addChild(new Sprite(RES.getRes("unlock" + this.data.grade + ".png")))
            .position.set((750 - 449) / 2, 580)
        //名字
        this.addChild(Tool.addText(
            foodData[this.data.grade].name,
            28,
            "#ffffff",
            undefined,
            560,
            (750 - 560) / 2,
            890
        ))
        //描述
        this.addChild(Tool.addText(
            foodData[this.data.grade].des,
            22,
            "#dac5fc",
            undefined,
            560,
            (750 - 560) / 2,
            931
        ))
    }



    start(data) {
        super.start();
    }

    initEvents() {
        this.onClick(this.closeBtn, this.onClick_closeBtn, this)
    }

    onClick_closeBtn() {
        this.hidePanel();
    }

    removeEvents() {
        this.removeClick(this.closeBtn, this.onClick_closeBtn, this)
    }

}

class Title extends Container {
    grade: number
    constructor(grade: number) {
        super();
        var msg = new Sprite(RES.getRes("unlockMsg.png"))
        this.addChild(msg);
        var textures = {}
        for (var i = 0; i < 10; i++)textures[i] = RES.getRes("n" + i + ".png");
        var num = new BitmapText(textures);
        num.textAlign = TEXT_ALIGN.LEFT;
        num.text = grade + "";
        this.addChild(num);
        var w = msg.width + num.width;
        msg.position.set((750 - w) / 2, 548);
        num.position.set(msg.x + msg.width, 548 + 4)
    }
}