
import { Container } from "../../engine/2d/display";
import { Panel } from "../views/Panel";
import { layers } from "../views/layers";
import { showWaiting, hideWaiting } from "./waitingCtrl";
import { Event } from "../../engine/2d/events";
import Tween from "../../engine/tween/Tween";
import { Ease } from "../../engine/tween/Ease";
import { Graphics } from "../../engine/2d/graphics";
import { showToast } from "./toastCtrl";
export default class PanelCtrl {
    /**
     * 父级容器
     */
    private _parent: Container;
    /**
     * 半透明黑色背景
     */
    private _bg: Graphics;
    /**
     * 所有的弹框
     */
    private stacks: Panel[] = [];

    private static _instance: PanelCtrl;
    static get instance() {
        return PanelCtrl._instance || (PanelCtrl._instance = new PanelCtrl())
    }

    init(parent: Container) {
        this._parent = parent;
        let bg = new Graphics()
            .beginFill(0, 1)
            .drawRect(
                layers.stageOffsetX - parent.x,
                layers.stageOffsetY - parent.y,
                layers.stageWidth,
                layers.stageHeight
            )
            .endFill();
        bg.visible = false;
        this._parent.addChild(bg);
        this._bg = bg;
    }

    /**
     * 关闭所有弹框
     */
    closeAll() {
        this.stacks.forEach(e => e.hidePanel());
    }

    show<T extends Panel>(cls: any, data?: any): T {
        showWaiting()
        const panel: T = new cls(data);
        this.add(panel);//必须得先加入栈，否则多重弹框重叠顺序就按加载熟读了
        this.stacks.push(panel);
        panel.onLoaded = () => {
            hideWaiting();
            this.updateView();
            //start只执行一边，考虑什么时候执行，多弹框的时候
            panel.start(data);
        }
        //资源加载失败时,RES的加载失败策略有问题，再检查
        panel.onLoadError = () => {
            hideWaiting();
            showToast("资源加载失败")
            panel.removeEventListener('onDestroy', this.onPanelHide, this);
            this.remove(panel);
        }

        return panel;
    }

    //同时show的时候，最后一个弹框会执行多次，考虑如何解决
    private updateView() {
        if (!this.stacks.length) {
            this._bg.visible = false;
            this._current = null;
            this._parent.visible = false;
        } else {
            //显示弹框层
            this._parent.visible = true;
            //如果首次出现弹框，加个动画
            if (this._bg.visible === false) {
                this._bg.visible = true;
                this._bg.alpha = 0;
                Tween.removeTweens(this._bg);
                Tween.get(this._bg).to({ alpha: 0.7 }, 200, Ease.cubicOut)
            }
        }

        for (let i = 0; i < this.stacks.length; i++) {
            if (i < this.stacks.length - 1) {
                this.stacks[i].visible = false;
            } else {
                this.stacks[i].visible = true;
                this.stacks[i].showAni();//这里动画有问题
                this._current = this.stacks[i];
            }
        }
    }

    /**
     * 添加进父级并添加事件
     * @param panel 
     */
    private add(panel: Panel) {
        this._parent.addChild(panel);
        panel.addEventListener('onDestroy', this.onPanelHide, this);
    }

    /**
     * 移除
     * @param panel 
     */
    private remove(panel: Panel) {
        this._parent.removeChild(panel);
        this.stacks = this.stacks.filter(e => e != panel);
    }

    /**
     * 弹框移除时执行
     * @param e 
     */
    private onPanelHide(e: Event) {
        const panel = e.target as Panel;
        panel.removeEventListener('onDestroy', this.onPanelHide, this);
        this.remove(panel);
        this.updateView();
    }

    //当前弹框
    private _current: Panel;

    /**
     * 关闭当前弹框
     */
    closeCurrent() {
        if (this._current) {
            this._current.hidePanel()
            // this._current.removeEventListener('onDestroy', this.onPanelHide, this);
            // this.remove(this._current);
            // this.updateView();
        }
    }

    destroy() {
        PanelCtrl._instance = null;
        this.stacks = null;
        this._current = null;
        this._parent = null;
        this._bg = null;
    }
}