/**
 * 删除了很多东西，需要webgl3d项目中看
 */


import { ProtoMovieEntity } from "./proto";
import { utils } from './pako/utils/common';
import inflate from "./pako/inflate";
const pako = {}
utils.assign(pako, inflate);

const Uint8ToString = function (u8a) {
    var CHUNK_SZ = 0x8000;
    var c = [];
    for (var i = 0; i < u8a.length; i += CHUNK_SZ) {
        c.push(String.fromCharCode.apply(null, u8a.subarray(i, i + CHUNK_SZ)));
    }
    return c.join("");
}

const actions = {

    loadAssets: (url, cb, failure) => {

        const req = new XMLHttpRequest()
        req.open("GET", url, true);
        req.responseType = "arraybuffer"
        req.onloadend = () => {
            actions.load_viaProto(req.response, cb, failure);
        }
        req.send()

    },

    load_viaProto: (arraybuffer, cb, failure) => {
        try {
            const inflatedData = pako["inflate"](arraybuffer);
            const movieData = ProtoMovieEntity.decode(inflatedData);
            let images = {};
            actions._loadImages(images, undefined, movieData, function () {
                movieData["ver"] = "2.0";
                cb({
                    movie: movieData,
                    images,
                })
            })
        } catch (err) {
            failure && failure(err);
            console.error(err);
            throw err;
        }
    },

    _loadImages: function (images, zip, movieData, imagesLoadedBlock) {
        if (typeof movieData === "object" && movieData.$type == ProtoMovieEntity) {
            var finished = true;
            if (!zip) {
                for (const key in movieData.images) {
                    if (movieData.images.hasOwnProperty(key)) {
                        const element = movieData.images[key];
                        const value = Uint8ToString(element);
                        images[key] = btoa(value)
                    }
                }
            }
            else {
                for (const key in movieData.images) {
                    if (movieData.images.hasOwnProperty(key)) {
                        const element = movieData.images[key];
                        const value = Uint8ToString(element);
                        if (images.hasOwnProperty(key)) {
                            continue;
                        }
                        finished = false;
                        zip.file(value + ".png").async("base64").then(function (data) {
                            images[key] = data;
                            actions._loadImages(images, zip, movieData, imagesLoadedBlock);
                        }.bind(this))
                        break;
                    }
                }
            }
            finished && imagesLoadedBlock.call(this)
        }
        else {
            var finished = true;
            for (var key in movieData.images) {
                if (movieData.images.hasOwnProperty(key)) {
                    var element = movieData.images[key];
                    if (images.hasOwnProperty(key)) {
                        continue;
                    }
                    finished = false;
                    zip.file(element + ".png").async("base64").then(function (data) {
                        images[key] = data;
                        actions._loadImages(images, zip, movieData, imagesLoadedBlock);
                    }.bind(this))
                    break;
                }
            }
            finished && imagesLoadedBlock.call(this)
        }
    },
}

export default (data, cb, failure) => {
    actions['loadAssets'](data, cb, failure);
}
