import { Sprite } from "../../../engine/2d/display";
import { RES } from "../../../module/RES";
import { Texture } from "../../../engine/2d/texture";

export class GameEle extends Sprite {

    _eleType = ""

    get eleType() { return this._eleType }
    set eleType(type) { this._eleType = type }

    constructor(eleType) {
        super()

        this._eleType = eleType

        switch (eleType + "") {
            case "2":
                this.texture = RES.getRes("ele2.png")
                this.x = 10
                this.y = 20
                break
            case "4":
                this.texture = RES.getRes("ele4.png")
                this.x = -2
                this.y = 20
                break
            case "8":
                this.texture = RES.getRes("ele8.png")
                this.x = 5
                this.y = 20
                break
            case "16":
                this.texture = RES.getRes("ele16.png")
                this.x = 12
                this.y = 15
                break
            case "32":
                this.texture = RES.getRes("ele32.png")
                this.x = 8
                this.y = 20
                break
            case "64":
                this.texture = RES.getRes("ele64.png")
                this.x = 8
                this.y = 16
                break
            case "128":
                this.texture = RES.getRes("ele128.png")
                this.x = 8
                this.y = 20
                break
            case "256":
                this.texture = RES.getRes("ele256.png")
                this.x = 8
                this.y = 20
                break
            case "512":
                this.texture = RES.getRes("ele512.png")
                this.x = 8
                this.y = 20
                break
            case "1024":
                this.texture = RES.getRes("ele1024.png")
                this.x = 10
                this.y = 20
                break
            case "2048":
                this.texture = RES.getRes("ele2048.png")
                this.x = 8
                this.y = 20
                break
            default:
                this.texture = Texture.EMPTY
                break
        }
    }


}