import { Rectangle } from '../../engine/2d/math/Rectangle';

import { Tool } from "../Tools";
import { Button } from "../../engine/2d/ui/Button";
import { MouseEvent } from "../../engine/2d/events/MouseEvent";
import { Panel } from "../../module/views/Panel";
import { RES } from "../../module/RES";
import { Sprite } from "../../engine/2d/display";
import { Graphics } from '../../engine/2d/graphics';
import { submit } from '../commonNet';
import { showWaiting, hideWaiting, showPanel } from '../../module/ctrls';
import { GameOverPanel } from './GameOverPanel';

/**
 * 弹框复制用
 */
export class QuitPanel extends Panel {
    get groupNames() { return ["quitPanel"] }

    closeBtn: Button;

    data: {
        grade: number,
        score: number,
        id: string//订单id
    }

    initUi() {
        //背景
        this.addChild(Tool.addSprite("quitPanelBg.png"));
        //关闭按钮
        this.closeBtn = new Button(RES.getRes("comCloseBtn.png"));
        this.closeBtn.position.set(630, 467);
        this.addChild(this.closeBtn);
        //继续闯关
        this.addChild(new Button(RES.getRes("jixuchuangguan.png")))
            .once(MouseEvent.CLICK, this.onClick_closeBtn, this)
            .position.set(398, 750)
        //退出本关，提交后，出结束弹框，
        this.addChild(new Button(RES.getRes("tuichubenguan.png")))
            .once(MouseEvent.CLICK, () => {
                showWaiting();
                //提交
                submit((s, res) => {
                    hideWaiting();
                    if (!s) return
                    this.hidePanel();
                    //显示结束弹框
                    showPanel(GameOverPanel, res.data)
                }, this.data.score, this.data.grade, this.data.id)
            }, this)
            .position.set(134, 750)
    }

    start(data) {
        super.start();
    }

    initEvents() {
        this.onClick(this.closeBtn, this.onClick_closeBtn, this)
    }

    onClick_closeBtn() {
        this.hidePanel();
    }

    removeEvents() {
        this.removeClick(this.closeBtn, this.onClick_closeBtn, this)
    }

}