import { Rectangle } from '../../engine/2d/math/Rectangle';

import { Tool } from "../Tools";
import { Button } from "../../engine/2d/ui/Button";
import { MouseEvent } from "../../engine/2d/events/MouseEvent";
import { Panel } from "../../module/views/Panel";
import { RES } from "../../module/RES";
import { Sprite } from "../../engine/2d/display";
import { Graphics } from '../../engine/2d/graphics';
import { Light } from '../common/Light';
import { TextField } from '../../engine/2d/text';
import { TEXT_ALIGN } from '../../engine/2d/const';
import { sendTbNet, TbNetName } from '../TaoBaoNet';
import { showWaiting, hideWaiting, getCurrentScene } from '../../module/ctrls';
import { PlayScene } from '../scenes/playScene/PlayScene';
import { GDispatcher } from '../../engine/2d/events';
import Tween from '../../engine/tween/Tween';
import { Ease } from '../../engine/tween/Ease';

const levelDes = {
    2: "33",
    4: "11",
    8: "11",
    16: "22",
    32: "22",
    64: "22",
    128: "22",
    256: "22",
    512: "22",
    1024: "22",
    2048: "22",
}

/**
 * 游戏结束
 */
export class GameOverPanel extends Panel {
    get groupNames() { return ["gameOverPanel"] }

    closeBtn: Button;
    returnBtn: Button;
    againBtn: Button;
    goEarnBtn: Button;

    data: {
        score: number;
        playDuration: number;
        grade: number;
        credits?: number//获取的积分
        creditsTimesToday?: number
    }
    initUi() {
        //加光
        this.addChild(new Light()).position.set(375, 735);
        //背景
        this.addChild(Tool.addSprite("gameOverPanelBg.png"));
        //关闭按钮
        this.closeBtn = new Button(RES.getRes("comCloseBtn.png"));
        this.closeBtn.position.set(612, 460);
        this.addChild(this.closeBtn);
        //分数
        var scoreTxt = new TextField();
        scoreTxt.fillColor = "#fada30";
        scoreTxt.bold = true;
        scoreTxt.size = 72;
        scoreTxt.textWidth = 550;
        scoreTxt.textAlign = TEXT_ALIGN.CENTER;
        scoreTxt.x = 90;
        scoreTxt.y = 660;
        scoreTxt.text = this.data.score + "";
        this.addChild(scoreTxt)
        //获得积分文案，根据数据判断
        if (this.data.credits) {
            this.addChild(Tool.addText(
                "获得" + this.data.credits + "积分（今日" + this.data.creditsTimesToday + "/3）",
                24,
                "#ddccfe",
                TEXT_ALIGN.CENTER,
                350,
                200,
                731
            ))
        }
        //印章
        var t: string;
        if (this.data.score >= 2000) {
            t = "scoreLevel3"
        } else if (this.data.score >= 1000) {
            t = "scoreLevel2"
        } else if (this.data.score >= 300) {
            t = "scoreLevel1"
        }
        if (t) {
            var yin = Sprite.from(t + ".png");
            yin.alpha = 0;
            yin.position.set(200, 600)
            yin.scale.set(2, 2);
            this.addChild(yin);
            Tween.get(yin).to({ x: 40, y: 497, alpha: 1, scaleX: 1, scaleY: 1 }, 500, Ease.quadIn)

        }
        //时间
        var timeTxt = new TextField();
        timeTxt.fillColor = "#ebde69";
        timeTxt.size = 28;
        timeTxt.textWidth = 270;
        timeTxt.textAlign = TEXT_ALIGN.CENTER;
        timeTxt.x = 117;
        timeTxt.y = 855;
        timeTxt.text = date_format(this.data.playDuration);
        this.addChild(timeTxt)
        //最高解锁
        var levelTxt = new TextField();
        levelTxt.fillColor = "#ebde69";
        levelTxt.size = 28;
        levelTxt.textWidth = 118;
        levelTxt.textAlign = TEXT_ALIGN.CENTER;
        levelTxt.x = 450;
        levelTxt.y = 855;
        levelTxt.text = this.data.grade + "";
        this.addChild(levelTxt)
        //最高解锁形容词
        var desTxt = new TextField();
        desTxt.fillColor = "#b093ea";
        desTxt.size = 18;
        desTxt.textWidth = 118;
        desTxt.textAlign = TEXT_ALIGN.CENTER;
        desTxt.x = 450;
        desTxt.y = 887;
        desTxt.text = "（" + levelDes[this.data.grade] + "）";
        this.addChild(desTxt);
        //返回首页按钮
        this.returnBtn = this.addChild(new Button(RES.getRes("fanhuishouye.png"))) as Button;
        this.returnBtn.position.set(117, 959);
        //再来一次按钮
        this.againBtn = this.addChild(new Button(RES.getRes("zailaiyiju.png"))) as Button;
        this.againBtn.position.set(383, 959);
        this.againBtn.visible = false;
        //去赚积分按钮
        this.goEarnBtn = this.addChild(new Button(RES.getRes("quzhuanjifen.png"))) as Button;
        this.goEarnBtn.position.set(383, 959);
        this.goEarnBtn.visible = false;
        //积分/次文案
        var needCreditsTxt = this.addChild(Tool.addText(
            "（" + Tool.globalData.joinNeedsCredits + "积分/次）",
            24,
            "#b093ea",
            TEXT_ALIGN.CENTER,
            233,
            383,
            1044
        ))
        needCreditsTxt.visible = false;
        //先获取积分，然后判断
        sendTbNet(TbNetName.getCredits, { activityId: Tool.globalData.activityId }, (s, res) => {
            //积分足够
            if (s && res.data.credits && res.data.credits >= Tool.globalData.joinNeedsCredits) {
                needCreditsTxt.visible = true;
                this.againBtn.visible = true;
            } else {
                this.goEarnBtn.visible = true;
            }
        })
    }


    start() {
        super.start();
    }

    initEvents() {
        this.onClick(this.closeBtn, this.onClick_closeBtn, this)
        this.onClick(this.returnBtn, this.onClick_closeBtn, this)
        this.onClick(this.againBtn, this.onClick_againBtn, this)
        this.onClick(this.goEarnBtn, this.onClick_goEarnBtn, this)
    }

    onClick_closeBtn() {
        // this.hidePanel();
        //回到首页
        sendTbNet(TbNetName.navigateBack, { delta: 1 }, () => { })
    }
    onClick_againBtn() {
        //发接口，重玩游戏 TODO
        showWaiting();
        sendTbNet(
            TbNetName.startGame,
            { activityId: Tool.globalData.activityId, nickName: Tool.globalData.nickName },
            (s, res: { data: { maxScore: number, unlockGrade: number, bombCount: number, exchangeCount: number, netCount: number } }) => {
                hideWaiting();
                this.hidePanel();
                if (s) {
                    var data = res.data
                    var playScene: PlayScene = getCurrentScene();
                    // playScene.resetGame(res.unlockGrade)//代加参数，方法
                    //修改道具数量
                    GDispatcher.dispatchEvent("updateProp", data.bombCount, data.exchangeCount, data.netCount)
                }
            }
        )
    }
    onClick_goEarnBtn() {
        //链接待填
        sendTbNet(TbNetName.navigateToOutside, { url: "" }, () => { })
    }

    removeEvents() {
        this.removeClick(this.closeBtn, this.onClick_closeBtn, this);
        this.removeClick(this.returnBtn, this.onClick_closeBtn, this);
        this.removeClick(this.againBtn, this.onClick_againBtn, this);
        this.removeClick(this.goEarnBtn, this.onClick_goEarnBtn, this);
    }

}

//转换时分秒
//时分秒换算
function date_format(micro_second) {
    // 总秒数
    var second = Math.floor(micro_second / 1000);
    // 天数
    var day = Math.floor(second / 3600 / 24);
    // 小时
    var hr = Math.floor(second / 3600 % 24);
    // 分钟
    var min = Math.floor(second / 60 % 60);
    // 秒
    var sec = Math.floor(second % 60);

    // return day + "天" + hr + "小时" + min + "分钟" + sec + "秒";
    // return (hr + day * 24) + "小时" + min + "分" + sec + "秒";
    var str = sec + "秒";
    if (min) str = min + "分" + str;
    if (hr + day * 24) str = (hr + day * 24) + "小时" + str;
    return str
};