import { Sprite } from "../engine/2d/display";
import { RES } from "../module/RES";
import { GTool } from "../module/tools/GTool";
import { TEXT_ALIGN } from "../engine/2d/const";
import { TextField } from "../engine/2d/text";
import { Graphics } from "../engine/2d/graphics";

/**
 * 定制，记录一些全局量和方法
 */
export class Tool {
    /**
     * 是否第一次
     */
    public static isFirst: boolean

    /**
     * 缓存key
     */
    public static cacheKey: string = "driftGuideTB"

    /**
     * 是否显示过寻宝屋
     */
    public static cacheKeyNoPrize: string = "antaParkourNoPrize"

    /**
     * 初始化一些数据，比如环境参数等
     */
    public static init() {
        //是否第一次，最后一次引导是否已过
        if (!GTool.readCache(this.cacheKey + "3")) {
            this.isFirst = true
        }
    }

    public static writeCache(count) {
        GTool.writeCache(this.cacheKey + count);
        // if (count == GuideStep.hole) this.isFirst = false;
    }

    /**
     * 一张图片
     * @param imageName 
     * @param x 
     * @param y 
     */
    public static addSprite(imageName: string, x: number = 0, y: number = 0): Sprite {
        var sprite = new Sprite(RES.getRes(imageName));
        sprite.x = x;
        sprite.y = y;
        return sprite
    }

    public static addText(
        txt: string,
        size: number,
        color: string = "#000000",
        align: TEXT_ALIGN = TEXT_ALIGN.CENTER,
        textWidth: number = 0,
        x: number = 0,
        y: number = 0
    ) {
        var text = new TextField();
        text.fillColor = color;
        text.size = size;
        text.textWidth = textWidth;
        text.textAlign = align;
        text.x = x;
        text.y = y;
        text.text = txt;
        return text
    }

    /**
     * 左上角原点
     * @param width 
     * @param height 
     * @param color 
     * @param alpha 
     * @param radius 
     * @param x 
     * @param y 
     */
    public static addRect(
        width: number,
        height: number,
        color: number = 0xff0000,
        alpha: number = 1,
        radius: number = 0,
        x: number = 0,
        y: number = 0,
    ) {
        var g = new Graphics();
        g.beginFill(color);
        g.alpha = alpha;
        if (!radius) {
            g.drawRect(0, 0, width, height)
        } else {
            g.drawRoundedRect(0, 0, width, height, radius)
        }
        g.endFill();
        g.position.set(x, y);
        return g
    }



    //进页面需要从小程序获得的数据
    public static globalData: {
        joinNeedsCredits: number,
        activityId: string,
        nickName: string,
        avatar: string,
        shareId?: string,//分享者的
        theme: string,//adult  kid
    };

}