import { Rectangle } from '../../engine/2d/math/Rectangle';

import { Tool } from "../Tools";
import { Button } from "../../engine/2d/ui/Button";
import { MouseEvent } from "../../engine/2d/events/MouseEvent";
import { Panel } from "../../module/views/Panel";
import { RES } from "../../module/RES";
import { Sprite } from "../../engine/2d/display";
import { Graphics } from '../../engine/2d/graphics';
import { showPanel, showToast, getCurrentScene, showWaiting, hideWaiting } from '../../module/ctrls';
import { TaskPanel } from './TaskPanel';
import { GDispatcher } from '../../engine/2d/events';
import { TextField } from '../../engine/2d/text';
import { PlayScene } from '../scenes/playScene/PlayScene';
import { sendTbNet, TbNetName } from '../TaoBaoNet';
import { GameOverPanel } from './GameOverPanel';
import { submit } from '../commonNet';

/**
 * 道具弹框，还没好
 */
export class PropPanel extends Panel {
    get groupNames() { return ["propPanel"] }

    closeBtn: Button;
    quitBtn: Button;
    getPropBtn: Button;

    //炸弹
    private bombCountTxt: TextField;
    private _bombCount: number;
    private bombArea: Graphics;
    get bombCount() {
        return this._bombCount;
    }
    set bombCount(value) {
        this._bombCount = value;
        this.bombCountTxt.text = value > 99 ? "99" : value + ""
    }
    //交换
    private exchangeCountTxt: TextField;
    private _exchangeCount: number;
    private exchangeArea: Graphics;
    get exchangeCount() {
        return this._exchangeCount;
    }
    set exchangeCount(value) {
        this._exchangeCount = value;
        this.exchangeCountTxt.text = value > 99 ? "99" : value + ""
    }
    //滤网
    private netCountTxt: TextField;
    private _netCount: number;
    private netArea: Graphics;
    get netCount() {
        return this._netCount;
    }
    set netCount(value) {
        this._netCount = value;
        this.netCountTxt.text = value > 99 ? "99" : value + ""
    }

    data: {
        bombCount: number,
        exchangeCount: number,
        netCount: number,
        grade: number,
        score: number,
        // id: string;
    }

    initUi() {
        //背景
        this.addChild(Tool.addSprite("propPanelBg.png"));
        //关闭按钮
        this.closeBtn = new Button(RES.getRes("comCloseBtn.png"));
        this.closeBtn.position.set(613, 460);
        this.addChild(this.closeBtn);
        //放弃按钮
        this.quitBtn = this.addChild(new Button(RES.getRes("fangqi.png")));
        this.quitBtn.position.set(116, 926);
        //获取道具按钮
        this.getPropBtn = this.addChild(new Button(RES.getRes("huoqudaoju.png")))
        this.getPropBtn.position.set(383, 926);
        //文案
        this.bombCountTxt = this.addChild(Tool.addText("", 28, "#ffffff", undefined, 70, 194, 728))
        this.exchangeCountTxt = this.addChild(Tool.addText("", 28, "#ffffff", undefined, 70, 377, 728))
        this.netCountTxt = this.addChild(Tool.addText("", 28, "#ffffff", undefined, 70, 556, 728))
        //点击区域
        this.bombArea = this.addChild(Tool.addRect(126, 142, undefined, 0, 0, 117, 717))
        this.exchangeArea = this.addChild(Tool.addRect(126, 142, undefined, 0, 0, 296, 717))
        this.netArea = this.addChild(Tool.addRect(126, 142, undefined, 0, 0, 476, 717))

    }
    start() {
        super.start();
        //需要添加事件，如果道具数量更新了，需要执行
        GDispatcher.addEvent("updateProp", this.updateProp, this);
        this.bombCount = this.data.bombCount;
        this.exchangeCount = this.data.exchangeCount;
        this.netCount = this.data.netCount;
    }

    initEvents() {
        this.onClick(this.closeBtn, this.onClick_closeBtn, this)
        this.onClick(this.quitBtn, this.onClick_closeBtn, this)
        this.onClick(this.getPropBtn, this.onClick_getPropBtn, this)
        this.onClick(this.bombArea, this.onClick_prop, this);
        this.onClick(this.exchangeArea, this.onClick_prop, this);
        this.onClick(this.netArea, this.onClick_prop, this);
    }

    onClick_closeBtn() {
        // this.hidePanel();//提交完成再关闭，弹其他弹窗
        //提交游戏
        showWaiting();
        submit((s, res) => {
            hideWaiting();
            if (s) {
                this.hidePanel();
                //显示结束弹框
                showPanel(GameOverPanel, res.data)
            }
        }, this.data.score, this.data.grade)
    }
    onClick_getPropBtn() {
        showPanel(TaskPanel)
    }

    updateProp(bombCount: number, exchangeCount: number, netCount: number) {
        this.bombCount = bombCount;
        this.exchangeCount = exchangeCount;
        this.netCount = netCount;
    }

    onClick_prop(e: MouseEvent) {
        let count: number, type: string;
        if (e.target == this.bombArea) {
            count = this.bombCount;
            type = "onClick_bombBtn"
        }
        else if (e.target == this.exchangeArea) {
            count = this.exchangeCount;
            type = "onClick_exchangeBtn"
        }
        else if (e.target == this.netArea) {
            count = this.netCount;
            type = "onClick_filterBtn"
        }
        if (!count) {
            showToast("暂无此道具，快去赚取道具吧")
            return
        }
        this.hidePanel();
        //执行道具的方法
        getCurrentScene()[type]();
    }


    removeEvents() {
        this.removeClick(this.closeBtn, this.onClick_closeBtn, this)
        this.removeClick(this.quitBtn, this.onClick_closeBtn, this)
        this.removeClick(this.getPropBtn, this.onClick_getPropBtn, this)
        this.removeClick(this.bombArea, this.onClick_prop, this);
        this.removeClick(this.exchangeArea, this.onClick_prop, this);
        this.removeClick(this.netArea, this.onClick_prop, this);
        GDispatcher.removeEvent("updateProp", this.updateProp, this)
    }

}