
import { destroyWaiting } from "./waitingCtrl";
import { Panel } from "../views/Panel";
import PanelCtrl from "./panelCtrl";
import SceneCtrl from "./sceneCtrl";
import { Scene } from "../views/Scene";
import { destroyToast } from "./toastCtrl";

export { showToast } from "./toastCtrl";
export * from "./waitingCtrl";

/**
 * 展示弹框
 * @param panel 弹框类
 * @param data 数据
 */
export const showPanel = (panel: any, data?: any) => {
    PanelCtrl.instance.show(panel, data)
}
/**
 * 关闭所有弹框
 */
export const closeAllPanels = () => {
    PanelCtrl.instance.closeAll();
}

/**
 * 关闭当前弹框
 */
export const closeCurrentPanel = () => {
    PanelCtrl.instance.closeCurrent();
}

/**
 * 替换场景
 * @param scene 
 * @param data 
 */
export const changeScene = (scene: any, data?: any) => {
    SceneCtrl.instance.change(scene, data)
}

/**
 * 获取当前场景
 */
export function getCurrentScene(): any {
    return SceneCtrl.instance.currentScene
}

/**
 * 销毁方法
 */
export function destroyAllCtrls() {
    destroyToast();
    destroyWaiting();
    PanelCtrl.instance.destroy();
    SceneCtrl.instance.destroy();
}