import { osType, TEXT_lINETYPE, devicePixelRatio, TEXT_ALIGN } from "../const";
import { Event } from "../events/Event";
import { MouseEvent } from "../events/MouseEvent";
import { FloatDisplay } from "../display/FloatDisplay";
import { TextField } from "./TextField";
import { InputText } from "./InputText";

/**
 * 可编辑文本，继承TextFieldNode
 * 点击的时候，出现InputText，并且是聚焦状态
 * 失去焦点的时候移除
 * @class InputText
 * @public
 * @since 1.0.0
 * @extends annie.FloatDisplay
 */
export class EditableText extends TextField {

    htmlElement: any;
    private _prompt: string = "";
    get prompt() {
        return this._prompt
    }
    set prompt(value: string) {
        if (this._prompt != value) {
            this._prompt = value;
            this["dirty"] = true;
            //如果无文本直接修改
            if (!this.htmlElement || !this.htmlElement.value) {
                this.text = this._prompt;
            }
        }
    }
    private _promptColor: string = "#eeeeee";
    get promptColor() {
        return this._promptColor
    }
    set promptColor(value: string) {
        if (this._promptColor != value) {
            this._promptColor = value;
            this["dirty"] = true;
            //如果无文本直接修改
            if (!this.htmlElement || !this.htmlElement.value) {
                this.fillColor = this._promptColor;
            }
        }
    }

    private _textColor: string = "#000000";
    get textColor() {
        return this._textColor
    }
    set textColor(value: string) {
        if (this._textColor != value) {
            this._textColor = value;
            this["dirty"] = true;
            //如果又文本直接修改
            if (this.htmlElement && this.htmlElement.value) {
                this.fillColor = this._textColor;
            }
        }
    }


    public constructor() {
        super();
        var s: EditableText = this;
        var remove = function () {
            //失去焦点
            s.htmlElement && s.htmlElement.blur();
            //隐藏
            s.htmlElement.style.display = "none";
            //赋值
            if (s.htmlElement.value) {
                s.text = s.htmlElement.value;
                s.fillColor = s.textColor;
            } else {
                s.text = s.prompt;
                s.fillColor = s.promptColor;
            }
        };

        this.addEventListener(MouseEvent.CLICK, function (e: Event) {
            if (!s.htmlElement) {
                s.htmlElement = document.createElement("input");
                s.htmlElement.type = "input";

                s.htmlElement.style.position = "absolute";
                s.htmlElement.style.display = "none";
                s.htmlElement.style.transformOrigin = s.htmlElement.style.WebkitTransformOrigin = "0 0 0";

                s.htmlElement.style.outline = "none";
                s.htmlElement.style.borderWidth = "thin";
                s.htmlElement.style.borderColor = "#000";
                //默认文案
                s.htmlElement.placeholder = "";

                /////////////////////设置边框//////////////
                s.htmlElement.style.borderStyle = "none";
                s.htmlElement.style.backgroundColor = "transparent";
                // s.htmlElement.style.borderStyle = "inset";
                // s.htmlElement.style.backgroundColor = "#fff";
                
                //color:blue; text-align:center"
                // if (this.inputType == 2) {
                //     this.htmlElement.style.lineHeight = lineSpacing + "px";
                // }

                s.stage.rootDiv.insertBefore(s.htmlElement, s.stage.rootDiv.childNodes[0]);
            }
            //font包括字体和大小
            s.htmlElement.style.font = s.size + "px " + this.font;
            s.htmlElement.style.color = s.textColor;
            s.htmlElement.style.textAlign = s["_textWidth"] ? s.textAlign : TEXT_ALIGN.LEFT;
            //     s.htmlElement.setAttribute("class", "inputTextFor");
            //    .inputTextFor:: -webkit - input - placeholder {
            //         text - align: center;
            //     }
            s.htmlElement.style.width = s.textWidth + "px";
            s.text = "";
            s.htmlElement.style.display = "block";
            s.htmlElement.focus();
            
            let mtx = s.transform.worldMatrix;
            let d = devicePixelRatio || 1;
            console.log(mtx)
            //位置
            s.htmlElement.style.transform = s.htmlElement.style.webkitTransform = "matrix(" + (mtx.a / d).toFixed(4) + "," + (mtx.b / d).toFixed(4) + "," + (mtx.c / d).toFixed(4) + "," + (mtx.d / d).toFixed(4) + "," + (mtx.tx / d).toFixed(4) + "," + (mtx.ty / d).toFixed(4) + ")";

            s.stage.once(MouseEvent.MOUSE_UP, remove);
        });

    }

}
