import { Rectangle } from '../../engine/2d/math/Rectangle';

import { Tool } from "../Tools";
import { Button } from "../../engine/2d/ui/Button";
import { MouseEvent } from "../../engine/2d/events/MouseEvent";
import { Panel } from "../../module/views/Panel";
import { RES } from "../../module/RES";
import { Sprite } from "../../engine/2d/display";
import { Graphics } from '../../engine/2d/graphics';
import { TaskType } from '../commonNet';
import { BitmapText } from '../../engine/2d/text';
import { TEXT_ALIGN } from '../../engine/2d/const';

const PrizeType = {
    [TaskType.doFollowShop]: "jiaohuan",//1
    [TaskType.doCollect]: "zhadan",//1
    [TaskType.doInvite]: "lvwang",//?
    [TaskType.doOrder]: "libao",//3
}

/**
 * 任务完成，点击领取弹框，还没好
 */
export class TaskCompletePanel extends Panel {
    get groupNames() { return ["taskCompletePanel"] }

    closeBtn: Button;

    data: {
        type: TaskType,//
        num?: number
    }
    initUi() {
        //背景
        this.addChild(Tool.addSprite("taskCompletePanelBg.png"));
        //关闭按钮
        this.closeBtn = new Button(RES.getRes("comCloseBtn.png"));
        this.closeBtn.position.set(630, 468);
        this.addChild(this.closeBtn);
        //开心收下
        this.addChild(new Button(RES.getRes("kaixinshouxia.png")))
            .once(MouseEvent.CLICK, this.onClick_closeBtn, this)
            .position.set(212, 846)
        //领奖内容，
        var image = this.addChild(new Sprite(RES.getRes(PrizeType[this.data.type] + ".png")))
        //位图文本
        var textures = {}
        textures["x"] = RES.getRes("nx.png");
        for (var i = 0; i < 10; i++)textures[i] = RES.getRes("n" + i + ".png");
        var num = new BitmapText(textures);
        num.textAlign = TEXT_ALIGN.LEFT;
        this.addChild(num);
        if (this.data.type == TaskType.doOrder) {
            num.text = "x3"
            num.position.set(473, 746)
            image.position.set(233, 612)
        } else {
            num.text = this.data.num ? "x" + this.data.num : "x1"
            num.position.set(420, 746)
            image.position.set(300, 638)
        }
    }


    start(data) {
        super.start();
    }

    initEvents() {
        this.onClick(this.closeBtn, this.onClick_closeBtn, this)
    }

    onClick_closeBtn() {
        this.hidePanel();
    }

    removeEvents() {
        this.removeClick(this.closeBtn, this.onClick_closeBtn, this)
    }

}