import { OverlapKeeperRecord } from './OverlapKeeperRecord';
import { Pool } from './Pool';

export class OverlapKeeperRecordPool extends Pool {
	/**
	 * @method create
	 * @return {OverlapKeeperRecord}
	 */
	create() {
		return new OverlapKeeperRecord();
	};

	/**
	 * @method destroy
	 * @param {OverlapKeeperRecord} record
	 * @return {OverlapKeeperRecordPool}
	 */
	destroy(record: OverlapKeeperRecord): OverlapKeeperRecordPool {
		record.bodyA = record.bodyB = record.shapeA = record.shapeB = null;
		return this;
	};
}
