/**
 * Created by rockyl on 2018/11/5.
 */

import { HashObject } from "../HashObject";
import { DisplayObject } from "../display/DisplayObject";

/**
 * 组件基类
 */
export class Component extends HashObject {
	/**
	 * 所依附的显示对象
	 */
	entity: DisplayObject;

	/**
	 * 是否有效
	 */
	protected _enabled: boolean

	constructor() {
		super();
		this._instanceType = "Component";
		this.onCreate();
	}

	/**
	 * 是否有效状态
	 */
	get enabled(): boolean {
		return this._enabled;
	}

	set enabled(value: boolean) {
		if (this._enabled !== value) {
			this._enabled = value;
			if (this._enabled) {
				this.onEnable();
			} else {
				this.onDisable();
			}
		}
	}

	/**
	 * 装配实体
	 * @param entity
	 */
	_setup(entity: DisplayObject) {
		this.entity = entity;
	}

	/**
	 * 卸载实体
	 */
	_unSetup() {
		this.entity = null;
	}

	/**
	 * 当组件被创建时
	 */
	onCreate() {

	}

	/**
	 * 当组件生效时
	 */
	onEnable() {

	}

	/**
	 * 当组件失效时
	 */
	onDisable() {

	}

	/**
	 * 更新
	 */
	onUpdate() {

	}

	/**
	 * 当组件被销毁时
	 */
	onDestroy() {

	}


	destroy() {
		this.onDestroy();

	}
}
