/**
 * @note   极验 - 第三方插件
 * @author 张晨辰
 * @email  zcc@duiba.com.cn
 * @create 2017-04-19 12:01:45
 * @update 2017-06-28 10:06:00 
 * @des    https://www.163yun.com/help/documents/294963579379175424
 * @dependencies <script type="text/javascript" src="//c.dun.163yun.com/js/c.js"></script>
 *         2.0  <script src="//cstaticdun.126.net/load.min.js"></script>  用下面这个
 */
let captchaIns;

export function initNECaptcha(options) {
  if (!options.captchaId) {
    return false;
  }
  $('body').append('<div class="captcha"><div id="check_wrapper" class="neCaptcha-dialog"></div></div>');

  var opts = {
    element: '#check_wrapper', // 可以是验证码容器id，也可以是HTMLElement
    captchaId: options.captchaId, // 这里填入申请到的验证码id
    width: options.width || 270, // 验证码组件显示宽度
    mode: options.mode || 'embed',
    onVerify: function (err, data) {
      if (!err) {
        $(".captcha").unbind("click");
        $('.captcha').remove();
        // data.validate = base64.encode(data.validate);
        options.callback && options.callback(data);
      }
    }
  }

  window["initNECaptcha"] && window["initNECaptcha"](opts, function (instance) {
    captchaIns = instance
    $(".captcha").click(function (e) {
      if (e.target.className == "captcha") {
        if (captchaIns) captchaIns.refresh()
      }
    });
  }, function (err) {
    console.log(err, 55655665)
    //初始化失败，点击黑色区域重新初始
    $(".captcha").click(function (e) {
      // if (e.target.className == "captcha") {
      $(".captcha").unbind("click");
      $('.captcha').remove();
      initNECaptcha(options)
      // }
    });
  });
  window["loading"] && window["loading"].close();
  $('.captcha').show();

};


//例子
initNECaptcha({
  captchaId: /*Tools.captchId*/111,
  callback: function (ret) {
    console.log(ret.validate)
  }
})

