
var fs = require('fs');
var path = require('path');
var gulp = require('gulp');
var gulpPngquant = require('gulp-pngquant');
var imageMin = require('gulp-imagemin');

function getFolders(dir) {
    return fs.readdirSync(dir)
        .filter(function (file) {
            return fs.statSync(path.join(dir, file)).isDirectory();
        });
}


// 要处理的图片文件夹路径
var altasPath = "./released/resource/"
//写入的图片，暂不用，直接覆盖上面的路径
var imageMinPath = "./imageMin/"

gulp.task('imageMin', function () {
    var folders = getFolders(altasPath);
    folders.map(function (folder) {
        //png用gulpPngquant压缩
        gulp.src(path.join(altasPath, folder, '/*.png'))
            // gulp.src(path.join(altasPath, folder, '/*.{png,jpg}'))
            .pipe(gulpPngquant())
            .pipe(gulp.dest(altasPath + folder));

        //jpg用imageMin压缩
        gulp.src(path.join(altasPath, folder, '/*.jpg'))
            .pipe(imageMin({ progressive: false }))
            .pipe(gulp.dest(altasPath + folder));

        // gulp.src(path.join(altasPath, folder, '/*.jpg'))
        //     .pipe(gulpPngquant())
        //     .pipe(gulp.dest(imageMinPath + folder));
    });
});

// 压缩 js 文件,webpack已压缩,效果一样
// 在命令行使用 gulp script 启动此任务，还没调试过
gulp.task('script', function () {
    // 1. 找到文件
    gulp.src('./released/*.js')
        // 2. 压缩文件
        .pipe(uglify(/*{ mangle: false }*/))
        // 3. 另存压缩后的文件
        .pipe(gulp.dest('./released'))
})

