import { Sprite } from "../engine/2d/display";
import { RES } from "../module/RES";
import { GTool } from "../module/tools/GTool";

/**
 * 定制，记录一些全局量和方法
 */
export class Tool {
    /**
     * 是否第一次
     */
    public static isFirst: boolean

    /**
     * 缓存key
     */
    public static cacheKey: string = "driftGuideTB"

    /**
     * 是否显示过寻宝屋
     */
    public static cacheKeyNoPrize: string = "antaParkourNoPrize"

    /**
     * 初始化一些数据，比如环境参数等
     */
    public static init() {
        //是否第一次，最后一次引导是否已过
        if (!GTool.readCache(this.cacheKey + "3")) {
            this.isFirst = true
        }
    }

    public static writeCache(count) {
        GTool.writeCache(this.cacheKey + count);
        // if (count == GuideStep.hole) this.isFirst = false;
    }

    /**
     * 一张图片
     * @param imageName 
     * @param x 
     * @param y 
     */
    public static addSprite(imageName: string, x: number = 0, y: number = 0): Sprite {
        var sprite = new Sprite(RES.getRes(imageName));
        sprite.x = x;
        sprite.y = y;
        return sprite
    }
    /**
     * 最大距离
     */
    public static maxDistance: number = 1000;

    //当前奖品的Icon图片，现在链接测试，注意需要更新
    public static curPrizeIcon: string //= "//yun.duiba.com.cn/images/201607/73htz55ih9.jpg"

    public static memberUrl: string;
    public static endTime: number;

    /**
     * 已经过期
     */
    public static hasExpired: boolean
    /**
     * 自己的分享shareId
     */
    public static openId: string

    //进页面需要从小程序获得的数据
    public static globalData: {
        activityId: string,
        nickName: string,
        avatar: string,
        shareId?: string,//分享者的
        theme:string,//adult  kid
    };

    /**
     * 分享者的信息
     */
    public static shareUserInfo: {
        "avatar": string,
        "nickName": string
    }
}