import { GDispatcher } from "../engine/2d/events";
import { showToast } from "../module/ctrls";

//接口枚举，包括需要调用淘宝的api，用是否含有兑吧区分，或者单独区分
export enum TbNetName {
    /**
     * 登录
     * activityId，nickName，avatar，shareId可选
     */
    login = "login",
    /**
     * 获取接力信息
     * activityId，shareId，不传获取自己的助力信息，传的话获取shareId的助力信息
     */
    getRelayInfo = "getRelayInfo",

    /**
     * 开始接口
     * activityId,nickName
     */
    startGame = "startGame",
    /**
     * 提交分数接口
     * activityId,distance
     */
    submitDistance = "submitDistance",
    /**
     * 验证分享助力,助力者的提交
     * activityId，shareId（分享者的），nickName，avatar，distance
     */
    doShareComplete = "doShareComplete",

    /**
     * 领奖接口，里面会校验是否是会员,直接传接口里返回的prizeInfo
     * activityId，ename,prizeId,prizeLevel,type,credits
     */
    collectionPrize = "collectionPrize",
    /**
     * 选择奖励
     * image，activityId，ename，name，prizeId，type，credits(不必须，到时确认)
     * 额外加个nickName
     */
    choosePrize = "choosePrize",
    /**
     * 获取可选择的奖品列表
     * activityId
     */
    getPrizeList = "getPrizeList",
    /**
     * 获取可领取的奖品信息，只会有一个，
     * activityId
     */
    getCollectionPrize = "getCollectionPrize",
    /**
     * 获取自己的分享Id
     * activityId
     */
    getShareId = "getShareId",

    /**
     * 获取游戏规则
     * activityId
     */
    getGameInfo = "getGameInfo",

    /**
     * 检查是否是会员
     * activityId
     */
    checkIsMember = "checkIsMember",


    //前端自己调用小程序的方法

    /**
     * 获取参数
     */
    getAppData = "mine.getAppData",
    /**
     * 小程序内跳到其他页面
     * url
     */
    navigateToOutside = "mine.navigateToOutside",
    /**
     * 跳转到小程序的其他页面
     * url
     */
    navigateTo = "mine.navigateTo",
    /**
     * 返回上一页或多页
     * delta，页面数，不传默认1
     */
    navigateBack = "mine.navigateBack",

    /**
     * 显示分享面板
     * openId
     */
    invite = "mine.showSharePanel",

    /**
     * 单纯接收来自小程序的信息，事件自行绑定
     */
    returnGame = "mine.returnGame",
}
//返回数据类型，到时再调整
interface dataIn {
    netName: TbNetName
    data: any
}
//记录数据
const data = {};

//淘宝小程序全局
const my = window["my"];

if (!window["develop"]) {
    //接收数据
    my.onMessage = function (e: dataIn) {
        //记录数据
        console.log("返回数据",e.netName, e.data)
        data[e.netName] = e.data;
        //触发事件，会考虑单独发过来的事件
        GDispatcher.dispatchEvent(e.netName, e.data)
    }
}

/**
 * 发送接口
 * @param netName 
 * @param parameter 
 * @param callback 
 */
export function sendTbNet(netName: TbNetName, parameter: any, callback: Function, hideMsg: boolean = false) {
    //本地开发，直接取数据
    if (window["develop"]) {
        // var url = "../../mock/miniTb/" + netName + ".json"
        // fetchAsync(url)
        //     .then((data) => {
        //         //记录数据
        //         data[name] = data;
        //         //回调
        //         callback(data.success, data);
        //     },()=>{})
        //直接用变量，方便注释
        setTimeout(() => {
            var returnData = mockData[netName];
            //记录数据
            data[netName] = returnData;
            if (returnData) {
                if (!hideMsg && !returnData.success) showToast(codeMsg[returnData.code] || "网络异常")
                callback(returnData.success, returnData);
            } else {
                if (!hideMsg) showToast("网络异常")
                callback(false)
            }

        }, 500)
        return
    }
    console.log("发送数据",netName,parameter)
    //向小程序发信息
    my.postMessage({
        netName: netName,
        parameter: parameter
    });
    let timeId: any;
    //事件回调
    let fun = function (d) {
        if (!hideMsg && !d.success) showToast(codeMsg[d.code] || "网络异常")
        GDispatcher.removeEvent(netName, fun);
        callback(d.success, d);
        clearTimeout(timeId);
    }
    //加事件
    GDispatcher.addEvent(netName, fun, null);
    //设置超时，意味着无返回数据
    timeId = setTimeout(() => {
        if (!hideMsg) showToast("网络超时")
        fun({ success: false })
    }, 5000)
}

/**
 * 获取数据
 * @param netName 
 */
export function getTbData(netName: TbNetName): { code?: string, success: boolean, data?: any } {
    return data[netName] || null;
}
//webview里调用无效，用postMessage去调
// export const navigateToOutside = (url) => {
//     my.call("navigateToOutside", {
//         url
//     }, (res) => {
//         // my.alert({ content: "success - " + JSON.stringify(res)})
//     });
// }

async function fetchAsync(url: string) {
    // await response of fetch call
    let response = await fetch(url);
    // only proceed once promise is resolved
    let data = await response.json();
    // only proceed once second promise is resolved
    return data;
}


// const { cloud } = window["getApp"]();
// const { function: fc } = cloud;
// fc.invoke("duiba.sign.doJoin", { signActivityId: 1 })
//     .then(res => {
//         console.log(res);
//     })

//模拟数据
const mockData = {
    //获取数据
    "mine.getAppData": {
        "success": true,
        "data": {
            "activityId": "111",
            "nickName": "开发环境",
            "avatar": "//yun.duiba.com.cn/developer/img/activityTool/slotMachine/virtual.png",
            // "shareId": "115564",
            "type": "kid"//adult
        }
    },
    //登录
    "login": {
        "code": 0,
        "data": {
            "endTime": "1586503134000",
            "isNewGuy": true,//是否新人
            "memberUrl": "//store.taobao.com/shop/view_shop.htm?user_number_id=2207623078795&extraInfo=%7B%22source%22%3A%22isvapp%22%2C%22activityId%22%3A%225e82d9db347ad421de487df7%22%2C%22entrance%22%3A%22duiba%22%7D",
            "isMember": false,
            "openId": "aaaaaa",
            "shareUserInfo": { //如果参数带了shareId就会传
                "avatar": "//yun.duiba.com.cn/developer/img/activityTool/slotMachine/virtual.png",
                "nickName": "aaa"
            }
        },
        "success": true,
        "errorMessage": "ok"
    },
    //获取接力信息
    "getRelayInfo": {
        "code": 10000,
        "data": {
            "image": "//yun.duiba.com.cn/aurora/assets/3c0cc7a660dc9f41af113eaa09ef3f512cd0669a.png",
            "list": [//为空表示没跑，第一项就是自己的
                {
                    "distance": 300,
                    "nickName": "cat",
                    "avatar": "//yun.duiba.com.cn/developer/img/activityTool/slotMachine/virtual.png",
                },
                {
                    "distance": 400,
                    "nickName": "cat",
                    "avatar": "//yun.duiba.com.cn/developer/img/activityTool/slotMachine/virtual.png",
                },
                {
                    "distance": 200,
                    "nickName": "cat",
                    "avatar": "//yun.duiba.com.cn/developer/img/activityTool/slotMachine/virtual.png",
                },

            ]
        },
        "success": true,
        "message": "成功"
    },
    //开始游戏，失败也继续
    "startGame": {
        "code": 10000,
        "success": true,
        "message": "成功"
    },
    //提交分数
    "submitDistance": {
        "code": 10000,
        "success": true,
        "message": "成功"
    },
    //助力者提交分数
    "doShareComplete": {
        "code": 10000,
        "success": true,
        "message": "成功"
    },
    //领奖
    "collectionPrize": {
        "code": 0,
        "success": true,
        "errorMessage": "ok"
    },
    //选择奖励
    "choosePrize": {
        "code": 0,
        "success": true,
        "errorMessage": "ok"
    },
    //获取可选择的奖品列表
    "getPrizeList": {
        "code": 10000,
        "data": {
            "list": [
                {
                    "image": "//yun.duiba.com.cn/aurora/assets/3c0cc7a660dc9f41af113eaa09ef3f512cd0669a.png",
                    "activityId": "5e82d9db347ad421de487df7",
                    "ename": "98e8af5681924b06beb09ca42215ef0c",
                    "createTime": 1585633755684,
                    "openId": "AAHg4uxWAKY3lWPqUtHiTOuF",
                    "deleteStatus": 1,
                    "name": "权益类型",
                    "updateTime": 1585633755684,
                    "_id": "5e82d9dbac0ac97ac0d45c61",
                    "type": 2,
                    "restStock": 0,//<=0 库存不足 
                    // "noCount":true 没有选择次数
                },
                {
                    "image": "//yun.duiba.com.cn/aurora/assets/3c0cc7a660dc9f41af113eaa09ef3f512cd0669a.png",
                    "activityId": "5e82d9db347ad421de487df7",
                    "credits": 20,
                    "createTime": 1585633755684,
                    "openId": "AAHg4uxWAKY3lWPqUtHiTOuF",
                    "deleteStatus": 1,
                    "name": "积分类型",
                    "totalStock": 100,
                    "updateTime": 1585633755684,
                    "_id": "5e82d9dbac0ac97ac0d45c62",
                    "type": 3,
                    // "noCount":true
                },
                // {
                //     "image": "//yun.duiba.com.cn/aurora/assets/3c0cc7a660dc9f41af113eaa09ef3f512cd0669a.png",
                //     "activityId": "5e82d9db347ad421de487df7",
                //     "createTime": 1585633755684,
                //     "openId": "AAHg4uxWAKY3lWPqUtHiTOuF",
                //     "deleteStatus": 1,
                //     "name": "实物类型",
                //     "totalStock": 100,
                //     "updateTime": 1585633755684,
                //     "_id": "5e82d9dbac0ac97ac0d45c63",
                //     "type": 4
                // },
                // {
                //     "image": "//yun.duiba.com.cn/aurora/assets/3c0cc7a660dc9f41af113eaa09ef3f512cd0669a.png",
                //     "activityId": "5e82d9db347ad421de487df7",
                //     "createTime": 1585633755684,
                //     "openId": "AAHg4uxWAKY3lWPqUtHiTOuF",
                //     "deleteStatus": 1,
                //     "name": "实物类型",
                //     "totalStock": 100,
                //     "updateTime": 1585633755684,
                //     "_id": "5e82d9dbac0ac97ac0d45c63",
                //     "type": 4
                // },
                // {
                //     "image": "//yun.duiba.com.cn/aurora/assets/3c0cc7a660dc9f41af113eaa09ef3f512cd0669a.png",
                //     "activityId": "5e82d9db347ad421de487df7",
                //     "createTime": 1585633755684,
                //     "openId": "AAHg4uxWAKY3lWPqUtHiTOuF",
                //     "deleteStatus": 1,
                //     "name": "实物类型",
                //     "totalStock": 100,
                //     "updateTime": 1585633755684,
                //     "_id": "5e82d9dbac0ac97ac0d45c63",
                //     "type": 4
                // }
            ]
        },
        "success": true,
        "message": "成功"
    },
    //获取可领取的奖品，就一个，看状态是否完成
    "getCollectionPrize": {
        "code": 10000,
        "data": {
            "prizeInfo": {
                "image": "//yun.duiba.com.cn/aurora/assets/3c0cc7a660dc9f41af113eaa09ef3f512cd0669a.png",
                "getMsg": "",
                "distance": 100,
                "openId": "AAHw4uxWAKY3lWHqUtPxyu4F",
                "getStatus": 1,//6是重新领取状态
                "type": 2,
                "prizeId": "5e82d9dbac0ac97ac0d45c61",
                "activityId": "5e82d9db347ad421de487df7",
                "ename": "98e8af5681924b06beb09ca42215ef0c",
                "prizeLevel": 1,
                "name": "权益类型",
                "_id": "5e82e283d86ed65836a807a7",
                "isComplete": false
            }
        },
        "success": true,
        "message": "成功"
    },
    //获取自己的分享Id
    "getShareId": {
        "code": 0,
        "data": {
            "shareId": "AAFdOf3jAJ9vbnS7X6h0Kros"
        },
        "success": true,
        "errorMessage": "ok"
    },
    //获取游戏规则
    "getGameInfo": {
        "code": 0,
        "data": {
            "rule": "aaaaaaaa\n阿斯达克风景区而离开期间为人情味人品全家人迫切居然跑去居然跑去让聘请外籍热切盼望进入强迫微软进去哦陪我认为金融排气昂克赛拉的骄傲快乐圣诞节爱丽丝的卡拉生当届阿里方污染破七万人哦强我弱\n阿三大苏打去微软亲热我去无人区热情而日期而且我人权为荣去微软去微软去微软去微软\nasd qw去问问请问我去饿请问齐威王恶趣味恶趣味恶趣味请问请问"
        },
        "success": true,
        "errorMessage": "ok"
    },
    //获取游戏规则
    "checkIsMember": {
        "code": 0,
        "data": {
            "memberUrl": "//store.taobao.com/shop/view_shop.htm?user_number_id=2207623078795&extraInfo=%7B%22source%22%3A%22isvapp%22%2C%22activityId%22%3A%225e82d9db347ad421de487df7%22%2C%22entrance%22%3A%22duiba%22%7D",
            "isMember": false,
        },
        "success": true,
        "errorMessage": "ok"
    },
}

/**
 * 错误码列表，字段不设枚举了
 */
export const codeMsg = {
    "210001": "服务器异常",
    "210002": "用户不存在",
    "210003": "邀请已达上限",
    "210004": "无法邀请自己",
    "210006": "该活动ID无效",
    "210009": "该活动暂未开始",
    "210010": "该分享ID不存在",
    "210012": "该用户暂未获奖",
    "210013": "领取失败",
    "210015": "该活动已删除",
    "210016": "该活动已经结束",
    "210017": "该奖品已达领取上线",
    "210018": "请先分享好友",
    "210019": "暂有奖品未领取",
    "210020": "暂有奖品未完成",
    "210021": "请先玩一局游戏",
    "210022": "请先选择奖品",
    "210023": "领取失败，库存不足",
    "210024": "请先成为会员",
    "210025": "奖品已经过期",
    "210026": "不能重复助力",
    "210028": "请至我的奖品页重新领取",//重新领取
}