import { Container, Stage } from "../../engine/2d/display";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from "../ctrls/sceneCtrl";

/**
 * 添加进舞台的所有层级
 * 仿白鹭的那套
 */
class Layers extends Container {
    private _bottomLayer: Container;
    private _sceneLayer: Container;
    private _popupLayer: Container;
    private _toastLayer: Container;
    private _topLayer: Container;
    private _shareLayer: Container;
    init(stage: Stage) {
        stage.addChild(this);
        var arr = [
            "_bottomLayer",
            "_sceneLayer",
            "_popupLayer",
            "_toastLayer",
            "_topLayer",
            "_shareLayer"
        ];
        for (var i = 0; i < arr.length; i++) {
            this[arr[i]] = new Container();
            //有些时候，定宽的时候，部分layer置顶，部分居中，再处理
            //为了都置顶和置左，stage的方式永远居中视窗，要么改stage永远左上为00
            this[arr[i]].y = this.stageOffsetY;
            //如果定宽这里没必要，肯定是0
            this[arr[i]].x = this.stageOffsetX;
            this.addChild(this[arr[i]]);
        }

        //初始化场景层级
        SceneCtrl.instance.init(this.sceneLayer)
        //初始化弹框层级
        PanelCtrl.instance.init(this.popupLayer)

        //弹框要居中适配，加个
        this.popupLayer.y = 0;

    }

    /**
     * 底图所在层级，比如统一的背景
     */
    get bottomLayer() { return this._bottomLayer }
    /**
     * 场景
     */
    get sceneLayer() { return this._sceneLayer }
    /**
     * 弹框
     */
    get popupLayer() { return this._popupLayer }
    /**
     * toast所在层级
     */
    get toastLayer() { return this._toastLayer }
    /**
     * 顶层，比如统一标题栏等，现在菊花圈也在top
     */
    get topLayer() { return this._topLayer }
    /**
     * 分享引导层
     */
    get shareLayer() { return this._shareLayer }
    /**
     * 舞台信息都放在layers里吧
     * 舞台可见高度，初始化后才能使用
     */
    get stageHeight() {
        if (!this.stage) return 0;
        return this.stage.viewRect.height;
    }
    /**
     * 舞台可见宽度
     */
    get stageWidth() {
        if (!this.stage) return 0;
        return this.stage.viewRect.width;
    }
    /**
     * 适配方式x两边偏移的量，固定宽度x为0
     */
    get stageOffsetX() {
        if (!this.stage) return 0;
        return this.stage.viewRect.x;
    }
    get stageOffsetY() {
        if (!this.stage) return 0;
        return this.stage.viewRect.y;
    }
    /**
     * 舞台中心点位置x
     */
    // get stageCenterX(): number {
    //     return this.stage.viewRect.x + this.stage.viewRect.width >> 1;
    // }
    /**
     * 舞台中心点位置y，layer位置做过偏移的就不对了，所以还是自行算吧
     */
    // get stageCenterY(): number {
    //     return this.stage.viewRect.y + this.stage.viewRect.height >> 1;
    // }
}

export const layers = new Layers();

//先执行，在淘宝小程序中重新进入会再次初始化
export function destroyLayers() {
    //所有层级移除，init会重新建
    layers.removeChildren();
    //从父级stage移除自己，init会重新加
    if (layers.parent) layers.parent.removeChild(layers)
}