
import { FrictionEquation } from '../equations/FrictionEquation';
import { Pool } from './Pool';
export class FrictionEquationPool extends Pool {
	/**
	 * @method create
	 * @return {FrictionEquation}
	 */
	create(): FrictionEquation {
		return new FrictionEquation();
	};

	/**
	 * @method destroy
	 * @param {FrictionEquation} equation
	 * @return {FrictionEquationPool}
	 */
	destroy(equation: FrictionEquation): FrictionEquationPool {
		equation.bodyA = equation.bodyB = null;
		return this;
	};
}
