import { Shape } from './Shape';
import { RaycastResult } from "../collision/RaycastResult";
import { Ray } from "../collision/Ray";
import { AABB } from "../collision/AABB";
import { vec2 } from '../math/vec2';
import { Utils } from "../utils/Utils"
var shallowClone = Utils.shallowClone
    , copy = vec2.copy;

export class Particle extends Shape {
    /**
     * Particle shape class.
     * @class Particle
     * @constructor
     * @param {object} [options] (Note that this options object will be passed on to the {{#crossLink "Shape"}}{{/crossLink}} constructor.)
     * @extends Shape
     * @example
     *     var body = new Body();
     *     var shape = new Particle();
     *     body.addShape(shape);
     */
    constructor(options) {
        options = options ? shallowClone(options) : {};
        options.type = Shape.PARTICLE;
        super(options);
        this.updateBoundingRadius();
        this.updateArea();
    }


    computeMomentOfInertia() {
        return 0; // Can't rotate a particle
    };

    updateBoundingRadius() {
        this.boundingRadius = 0;
    };

    /**
     * @method computeAABB
     * @param  {AABB}   out
     * @param  {Array}  position
     * @param  {Number} angle
     */
    computeAABB(out: AABB, position: Float32Array/*, angle*/) {
        copy(out.lowerBound, position);
        copy(out.upperBound, position);
    };
}
