
import { Tool } from "./Tools";
import { Stage } from "../engine/2d/display/Stage";
import { StageScaleMode, RENDERER_TYPE } from "../engine/2d/const";
import Tween from "../engine/tween/Tween";
import { Event } from "../engine/2d/events/Event";
import { layers } from "../module/views/layers";
import { RES } from "../module/RES";
import { changeScene, showWaiting, hideWaiting, showToast } from "../module/ctrls";
import { StartScene } from "./scenes/StartScene";
import { PlayScene } from "./scenes/playScene/PlayScene";
import { sendTbNet, TbNetName, getTbData } from "./TaoBaoNet";



//天眼监控
window.addEventListener("load", function () {
    window['_error_storage_'] = [];
    window['ERROR_CONFIG'] = {
        client: "duiba-game",
        pageId: "drift111",
        imgUrl: "http://retcode.tuipink.com/report?"
    };
    function r() {
        window['_error_storage_'] && window['_error_storage_'].push([].slice.call(arguments))
    }
    window.addEventListener && window.addEventListener("error", r, true);
    var t = 3,
        n = function e() {
            var r = document.createElement("script");
            r.async = !0, r.src = "//yun.tuia.cn/tuia/skyeye/skyeye.js", r.crossOrigin = "anonymous", r.onerror =
                function () {
                    t-- , t > 0 && setTimeout(e, 1500)
                }, document.head && document.head.appendChild(r)
        };
    setTimeout(n, 1500);
    // const str = GFun.replace('1{0}2',['haha']);
    // alert(str);
    new Main();
});

export class Main {
    stage: Stage
    constructor() {
        //设计尺寸按750*1624来
        this.stage = new Stage("cusEngine", 750, 1624, 60, StageScaleMode.FIXED_WIDTH, RENDERER_TYPE.WEBGL);
        //启动循环
        Stage.flushAll();
        //加入两个Tween
        // Stage.addUpdateObj(TweenSimple);
        Stage.addUpdateObj(Tween);
        this.stage.addEventListener(Event.INIT_STAGE, this.onAddToStage.bind(this));
    }

    private async onAddToStage() {

        //初始化层级
        layers.init(this.stage);
        //初始化资源
        await RES.loadConfig("res.json", window["resPath"] || "../resource/");
        await RES.loadGroup("common");
        //隐藏加载中
        if (document.getElementById("__loading__")) document.getElementById("__loading__").style.display = "none";
        //打开开始场景
        // changeScene(StartScene); return;
        //获取数据,，必成功
        showWaiting();
        sendTbNet(TbNetName.getAppData, {}, (s, res) => {
            Tool.globalData = res.data;
            changeScene(PlayScene,Tool.globalData.gameObj);
            // changeScene(StartScene);
        })


    }


}

