import { Module } from "./Module";
import Tween from "../../engine/tween/Tween";
import { Ease } from "../../engine/tween/Ease";
import { MouseEvent } from "../../engine/2d/events";
import { Sprite, Container } from "../../engine/2d/display";
import { RES } from "../RES";



export class Panel extends Module {


    initUi() {
        super.initUi()

    }

    private isShowing: boolean
    showAni() {
        if (this.isShowing) return;
        this.isShowing = true;
        // let oriY = this.y || 0;
        // this.y = -200;
        // Tween.get(this)
        //     .to({ y: oriY }, 500, Ease.quartOut)
        //     .call(() => {
        //         this.isShowing = false;
        //     })
        //统一修改
        this.anchor.set(375, 1624/2);
        this.scale.set(0.1, 0.1)
        Tween.get(this).to({ scaleX: 1, scaleY: 1 }, 500, Ease.backOut);
    }

    initEvents() {
        this.closeBtns.forEach(
            btn => { if (btn) btn.addEventListener(MouseEvent.CLICK, this.hidePanel, this) }
        )
    }
    removeEvents() {
        this.closeBtns.forEach(
            btn => { if (btn) btn.removeEventListener(MouseEvent.CLICK, this.hidePanel, this) }
        )
    }

    /**
     * 需要的放入，不重复写关闭按钮事件
     */
    protected get closeBtns(): any[] { return [this['closeBtn']] }

    hidePanel() {
        this.destroy();
    }
}