import { Rectangle } from '../../engine/2d/math/Rectangle';

import { Tool } from "../Tools";
import { Button } from "../../engine/2d/ui/Button";
import { MouseEvent } from "../../engine/2d/events/MouseEvent";
import { Panel } from "../../module/views/Panel";
import { RES } from "../../module/RES";
import { Sprite } from "../../engine/2d/display";
import { Graphics } from '../../engine/2d/graphics';

/**
 * 奖品擦肩而过的弹框
 */
export class PanelBase extends Panel {
    get groupNames() { return ["common", "rulePanel"] }
    bg
    closeBtn: Button;
    /**
     * 关闭之后的回调
     */
    closeFun;
    initUi() {
        //背景
        this.bg = this.addChild(Tool.addSprite("rulePanelBg.png", (750 - 600) / 2, 200));
        //关闭按钮
        this.closeBtn = new Button(RES.getRes("comCloseBtn.png"));
        this.closeBtn.position.set(650, 380);
        this.addChild(this.closeBtn);
    }


    start(data) {
        super.start();

    }

    initEvents() {
        this.onClick(this.closeBtn, this.onClick_closeBtn, this)
    }

    onClick_closeBtn() {
        this.hidePanel()
    }

    removeEvents() {
        this.removeClick(this.closeBtn, this.onClick_closeBtn, this)
    }

}