
import { RES } from "../../module/RES";

let soundOn = true;
if (localStorage.getItem('soundOn') == null) {
    soundOn = true;
    localStorage.setItem('soundOn', "1");
}
else
    soundOn = localStorage.getItem('soundOn') == '1';

let bgOn = true;
if (localStorage.getItem('bgOn') == null) {
    bgOn = true;
    localStorage.setItem('bgOn', "1");
}
else
    bgOn = localStorage.getItem('bgOn') == '1';

export const getSoundOn = () => {
    return soundOn
}
export const getBgOn = () => {
    return bgOn
}

export const toggleSound = () => {
    soundOn = !soundOn;
    localStorage.setItem('soundOn', soundOn ? "1" : "0")
}

export const toggleBgStatus = () => {
    bgOn = !bgOn;
    localStorage.setItem('bgOn', bgOn ? "1" : "0")
}

export const toggleBg = () => {
    bgOn = !bgOn;
    localStorage.setItem('bgOn', bgOn ? "1" : "0")
    if (bgMusic) {
        if (!bgOn) {
            bgMusic.stop();
        }
    } else {
        if (bgOn) {
            playBg();
        }
    }
}

let bgMusic: Howl
export const stopBg = () => {
    if (bgMusic) {
        bgMusic.stop();
    }
};

export const playBg = async () => {
    if (!bgMusic) {
        bgMusic = await RES.getResAsync('mapBg.mp3');
    }
    bgMusic.play();
    bgMusic.loop()
}

/**
 * 具体需要时改
 */
export enum SoundType {
    cloud = 'cloud',
    countNum = 'countNum',
    countGo = 'countGo',
    hit = 'hit',
    showPanel = 'showPanel',
    countDown = "countDown",
    speedUp = "speedUp",
}

/**
 * 
 * @param type 
 */
export const playSound = (type: SoundType) => {
    if (!soundOn) return;
    const sound: Howl/*:Sound*/ = RES.getRes(type + ".mp3");
    if (sound) {
        sound.play();
    } else {
        RES.getResAsync(type + ".mp3")
        sound.play();
    }
}