

/**
 * 单独定义的材质没有意义，与ContactMaterial使用
 * Defines a physics material. To be used with {{#crossLink "ContactMaterial"}}{{/crossLink}}.
 * @class Material
 * @constructor
 * @author schteppe
 * @example
 *     // Create a wooden box
 *     var woodMaterial = new Material();
 *     var boxShape = new Box({
 *         material: woodMaterial
 *     });
 *     body.addShape(boxShape);
 */
export class Material {
    private static idCounter = 0;

    /**
     * The material identifier. Read only.
     * @readonly
     * @property id
     * @type {Number}
     */
    private id: number
    constructor() {
        this.id = Material.idCounter++;
    }
}


