import { sendTbNet, TbNetName } from "./TaoBaoNet";
import { Tool } from "./Tools";
import { GDispatcher } from "../engine/2d/events";
import { getSoundOn, toggleSound } from "../module/ctrls/soundCtrl";

export enum TaskType {
    doFollowShop = "doFollowShop",
    doInvite = "doInvite",
    doCollect = "doCollect",
    doOrder = "doOrder"
}
/**
 * 和消耗道具接口保持一致
 */
export enum PropType {
    boom = 1,
    exchange = 2,
    net = 3,
}
/**
 * 
 * @param callback 
 * @param score 
 * @param grade 
 * @param id 
 * @param isFinal 是否最终提交，默认是的
 */
export function submit(
    callback: (s: boolean, res?: any) => void,
    score: number,
    grade: number,
    isFinal: boolean = true,
    hideMsg: boolean = false
) {
    sendTbNet(
        TbNetName.submit,
        {
            activityId: Tool.globalData.activityId,
            grade: grade,
            score: score,
            type: isFinal ? 1 : 0,
            playId: Tool.globalData.gameObj.id
        },
        (s, res) => {
            callback(s, res)
        },
        hideMsg
    )
}

/**
 * 获取道具数量
 * 自动派发事件
 * 暂时可能不需要加回调，需要时再说
 */
export function getTools() {
    sendTbNet(
        TbNetName.getTools,
        { actitvityId: Tool.globalData.activityId },
        (s, res) => {
            //如果成功就更新道具数量
            if (s) GDispatcher.dispatchEvent("updateProp", res.data.bombCount, res.data.exchangeCount, res.data.netCount)
        },
        true
    )
}

/**
 * 
 * @param callback 回调
 * @param type 道具类型
 */
export function useTools(callback: (s: boolean) => void, type: PropType) {
    sendTbNet(
        TbNetName.useTools,
        {
            activityId: Tool.globalData.activityId,
            type: type,
            playId: Tool.globalData.gameObj.id
        },
        (s) => { callback(s); }
    )
}

/**
 * 处理app传过来的音乐状态
 */
export function getSoundStatus() {
    var isOn = Tool.globalData.openSound;
    //传入的是播放，但是自身关闭了，需要开启
    if (isOn && !getSoundOn()) {
        toggleSound();
        return true;
    }
    //传入的是关闭的，但是自身开启，需要关闭
    if (!isOn && getSoundOn()) {
        toggleSound();
        return false;
    }
    //其他情况就是一致的
    return isOn
}
