import { Rectangle } from '../../engine/2d/math/Rectangle';

import { Tool } from "../Tools";
import { Button } from "../../engine/2d/ui/Button";
import { MouseEvent } from "../../engine/2d/events/MouseEvent";
import { Panel } from "../../module/views/Panel";
import { RES } from "../../module/RES";
import { Sprite } from "../../engine/2d/display";
import { Graphics } from '../../engine/2d/graphics';
import { layers } from '../../module/views/layers';
import Tween from '../../engine/tween/Tween';

/**
 * 任务弹框，还没好
 */
export class TaskPanel extends Panel {
    get groupNames() { return ["taskPanel"] }

    closeBtn: Button;

    initUi() {
        //底部适配,原先都是居中的，
        this.y = (layers.stageHeight - 1624) / 2
        //背景
        this.addChild(Tool.addSprite("taskPanelBg.png")).position.set(0, 1624 - 1075);
        //关闭按钮
        this.closeBtn = new Button(RES.getRes("comCloseBtn.png"));
        this.closeBtn.position.set(681, 870);
        this.addChild(this.closeBtn);
        //四个按钮
    }

    //动画重写，从下往上
    showAni() {
        var oriY = this.y;
        this.y += this.getLocalBounds().height;
        Tween.get(this)
            .to({ y: oriY }, 500)
    }

    start(data) {
        super.start();
    }

    initEvents() {
        this.onClick(this.closeBtn, this.onClick_closeBtn, this)
    }

    onClick_closeBtn() {
        this.hidePanel();
    }

    removeEvents() {
        this.removeClick(this.closeBtn, this.onClick_closeBtn, this)
    }

}