import { Rectangle } from '../../engine/2d/math/Rectangle';

import { Tool } from "../Tools";
import { Button } from "../../engine/2d/ui/Button";
import { MouseEvent } from "../../engine/2d/events/MouseEvent";
import { Panel } from "../../module/views/Panel";
import { RES } from "../../module/RES";
import { Sprite } from "../../engine/2d/display";
import { Graphics } from '../../engine/2d/graphics';

/**
 * 任务完成，点击领取弹框，还没好
 */
export class TaskCompletePanel extends Panel {
    get groupNames() { return ["taskCompletePanel"] }

    closeBtn: Button;

    initUi() {
        //背景
        this.addChild(Tool.addSprite("taskCompletePanelBg.png"));
        //关闭按钮
        this.closeBtn = new Button(RES.getRes("comCloseBtn.png"));
        this.closeBtn.position.set(630, 468);
        this.addChild(this.closeBtn);
        //开心收下
        this.addChild(new Button(RES.getRes("kaixinshouxia.png")))
            .once(MouseEvent.CLICK, this.onClick_closeBtn, this)
            .position.set(212, 846)
        //领奖内容，注意发接口刷新道具数量，更新场景道具数量

    }

    data: {

    }

    start(data) {
        super.start();
    }

    initEvents() {
        this.onClick(this.closeBtn, this.onClick_closeBtn, this)
    }

    onClick_closeBtn() {
        this.hidePanel();
    }

    removeEvents() {
        this.removeClick(this.closeBtn, this.onClick_closeBtn, this)
    }

}