import { sendTbNet, TbNetName } from "./TaoBaoNet";
import { Tool } from "./Tools";
import { GDispatcher } from "../engine/2d/events";


/**
 * 
 * @param callback 
 * @param score 
 * @param grade 
 * @param isFinal 是否最终提交，默认是的
 */
export function submit(callback: (s: boolean, res?: any) => void, score: number, grade: number, id: string, isFinal: boolean = true) {
    sendTbNet(
        TbNetName.submit,
        {
            activityId: Tool.globalData.activityId,
            grade: grade,
            score: score,
            type: isFinal ? 1 : 0,
            playId: id
        },
        (s, res) => {
            callback(s, res)
        }
    )
}

/**
 * 获取道具数量
 * 自动派发事件
 * 暂时可能不需要加回调，需要时再说
 */
export function getTools() {
    sendTbNet(
        TbNetName.getTools,
        { actitvityId: Tool.globalData.activityId },
        (s, res) => {
            //如果成功就更新道具数量
            if (s) GDispatcher.dispatchEvent("updateProp", res.data.bombCount, res.data.exchangeCount, res.data.netCount)
        },
        true
    )
}
