import { GTool } from "./tools/GTool";


/**
 * 接口枚举名，
 * 暂时就用作路径了
 */
export enum NetName {
    home = "drawGame.index",//
    start = "drawGame.start",//
    buy = "drawGame.exchangeTips",//gateNum,timestamp,token(校验token（md5(gateNum + timestamp + "becheery@dui88")）)
    submit = "drawGame.submit",//gateNum,token(校验token（md5(openId + gateNum + "becheery@dui88")）)//疑问openId
    //task: "drawGame.taskList",//
    exchangePowers = "drawGame.exchangePowers",//timestamp,token(校验token（md5(openId + timestamp + "becheery@dui88")）)
    help = "drawGame.help",//inviterId(邀请人的openId)
    uploadUserInfo = "userInfo.upload",//userNick,avatar
    //下面这种星速台格式，需要重置
    signData = "/projectx/{projectId}/join_1/data.do",
    signIn = "/projectx/{projectId}/join_1/join.do",

    IMG_URL = '/customActivity/duiba/imgUrl',
}
/**
 * 需要替换的参数
 */
const urlReplaceConfig = {
    "{projectId}": getProjectId()
}

/**
 * 接口路径参数替换，
 */
export function netUrlReplace() {
    for (let i of Object.keys(NetName)) {
        for (let j of Object.keys(urlReplaceConfig)) {
            NetName[i] = NetName[i].replace(new RegExp(j, "g"), urlReplaceConfig[j]);
        }
    }
}
//进页面就可以执行了吧,考虑上面是否直接用匿名函数执行
netUrlReplace()

//记录的接口数据
const data = {};
/**
 * 获取接口数据
 * @param netName TbNetName
 */
export function getNetData(netName: NetName) {
    return data[netName] || null;
}
/**
 * 通用发接口方法
 * @param callback 回调
 * @param netName 路径
 * @param param 参数
 * @param type "get" | "post"默认get
 * @param headers 头部，默认没有
 * @param dataType 返回类型，默认json
 */
export function sendNet(
    callback: (success: boolean, res?: any) => void,
    netName: NetName | string,
    param: any,
    type: "get" | "post" = "get",
    headers?: any,
    dataType: string = "json",
) {
    var obj = {
        type,
        url: netName,
        //不缓存
        cache: false,
        dataType,
        data: param,
        async: true,
        success: (result) => {
            //记录数据，失败记不记，待考虑
            /*if(result.success)*/data[netName] = result//.data;
            callback(result.success, result/*.data*/)
        },
        error: (message) => {
            callback(false);
        }
    }
    //上传图片加额外headers
    if (headers) obj["headers"] = headers;
    /*{
       "Content-Type": "application/json",
       'Authorization': 'my-auth-token'
   }*/

    $.ajax(obj);
}

const projectxString = "projectx/";
let projectId: string;
/**
 * 获取链接上的projectId
 */
export function getProjectId(): string {
    //已经获取过，直接返回
    if (projectId) return projectId;

    let windowUrl = window.location.href;
    let splitArr = windowUrl.split(projectxString);
    //不存在直接用projectId
    if (splitArr.length != 2) return projectId = "projectId";
    let start = windowUrl.indexOf(projectxString) + projectxString.length;
    let end = splitArr[1].indexOf("/");
    return projectId = windowUrl.substr(start, end);
}

/**
 * 曝光埋点
 * @param area 
 */
export function showLog(area: number) {
    var appId = GTool.getParamString("appID") || window["appId"];
    var oaId = getProjectId()//window["projectId"];
    const exposure = {
        dpm: appId + `.110.${area}.1`,
        dcm: `202.${oaId}.0.0`,
        // consumerId: Buried.consumerId,
        appId: appId,
        domain: '//embedlog.duiba.com.cn',
    };
    sendNet(
        () => { },
        exposure.domain + '/exposure/standard',
        exposure,
        "get",
        null,
        "jsonp"
    )
}

/**
 * 点击埋点
 * @param area 
 */
export function clickLog(area: number) {
    var appId = GTool.getParamString("appID") || window["appId"];
    var oaId = getProjectId()//window["projectId"];
    const exposure = {
        dpm: appId + `.110.${area}.1`,
        dcm: `202.${oaId}.0.0`,
        // consumerId: Buried.consumerId,
        appId: appId,
        domain: '//embedlog.duiba.com.cn',
    };
    sendNet(
        () => { },
        '/log/click',
        exposure,
        "get",
        null,
        "jsonp"
    )
}