import { Body } from "../objects/Body";
import { Shape } from "../shapes/Shape";


export class OverlapKeeperRecord {

    shapeA: Shape;
    shapeB: Shape;
    bodyA: Body;
    bodyB: Body;

    /**
     * Overlap data container for the OverlapKeeper
     * @class OverlapKeeperRecord
     * @constructor
     * @param {Body} bodyA
     * @param {Shape} shapeA
     * @param {Body} bodyB
     * @param {Shape} shapeB
     */
    constructor(bodyA?: Body, shapeA?: Shape, bodyB?: Body, shapeB?: Shape) {

        this.shapeA = shapeA;

        this.shapeB = shapeB;

        this.bodyA = bodyA;

        this.bodyB = bodyB;
    }

    /**
     * Set the data for the record
     * @method set
     * @param {Body} bodyA
     * @param {Shape} shapeA
     * @param {Body} bodyB
     * @param {Shape} shapeB
     */
    set(bodyA: Body, shapeA: Shape, bodyB: Body, shapeB: Shape): void {
        // OverlapKeeperRecord.call(this, bodyA, shapeA, bodyB, shapeB);
        this.shapeA = shapeA;

        this.shapeB = shapeB;

        this.bodyA = bodyA;

        this.bodyB = bodyB;
    };
}
