export interface RendererOptions {
    /**
     * canvas标签,注意只有一种情况，canvasRender用于画质缓存canvas时不用，其他时候都必带
     */
    htmlElement?: HTMLCanvasElement
    /**
     * If the render view is transparent
     * 设置透明，则背景色无效
     */
    transparent?: boolean;
    /**
     * sets antialias (only applicable in chrome at the moment)
     * 
     */
    antialias?: boolean;
    /**
     * enables drawing buffer preservation,
     * enable this if you need to call toDataUrl on the webgl context
     */
    preserveDrawingBuffer?: boolean;
    /**
     * The background color of the rendered area
     * (shown if not transparent).0x000000
     */
    backgroundColor?: number;
    /**
     * If true will Math.floor() x/y values when rendering,
     *  stopping pixel interpolation.
     */
    roundPixels?: boolean;
}