import Filter from "../Filter";
import { defaultVert } from "../defaultVerts";


const blurFrag = [
    "precision highp float;",
    "varying lowp vec2 vTextureCoord;",
    "uniform sampler2D uSampler;",
    // "uniform float stepValue;",
    "uniform float radius;",
    // 卷积大小
    "const int KernelSize = 9;",

    "void main(){",


    // "int i;",
    "vec4 sum = vec4(0.0);",

    //用来存储3x3的卷积矩阵
    "float Kernel[KernelSize];",
    "Kernel[6] = 1.0; Kernel[7] = 2.0; Kernel[8] = 1.0;",
    "Kernel[3] = 2.0; Kernel[4] = 4.0; Kernel[5] = 2.0;",
    "Kernel[0] = 1.0; Kernel[1] = 2.0; Kernel[2] = 1.0;",


    "float fStep = radius;",
    //像素点偏移位置
    "vec2 Offset[KernelSize];",
    "Offset[0] = vec2(-fStep,-fStep); Offset[1] = vec2(0.0,-fStep); Offset[2] = vec2(fStep,-fStep);",
    "Offset[3] = vec2(-fStep,0.0);    Offset[4] = vec2(0.0,0.0);    Offset[5] = vec2(fStep,0.0);",
    "Offset[6] = vec2(-fStep, fStep); Offset[7] = vec2(0.0, fStep); Offset[8] = vec2(fStep, fStep);",

    "for (int i = 0; i < KernelSize; i++){",
    "vec4 tmp = texture2D(uSampler, vTextureCoord.xy + Offset[i]);",
    "sum += tmp * Kernel[i];",
    "}",

    "gl_FragColor = sum/16.0;",
    "}"
].join("\n")
//简单新能高点的模糊滤镜
export default class BlurFilterNew extends Filter {
    private _blur: number;
    get blur() {
        return this._blur;
    }
    /**
     * 系数0到1
     */
    set blur(value) {
        if (this._blur === value) return;
        if (value > 1) value = 1;
        if (value < 0) value = 0;
        this._blur = value
        this.uniforms.radius = 0.009;//修复中，先不用
    }
    /**
     * 
     * @param blur 模糊系数 0到1
     */
    constructor(blur: number = 0.5) {
        super(defaultVert, blurFrag);
        this.blur = blur;
        //先固定吧
        // this.uniforms.dir = [1.0, 1.0];
    }
}