import { Rectangle } from '../../engine/2d/math/Rectangle';

import { Tool } from "../Tools";
import { Button } from "../../engine/2d/ui/Button";
import { MouseEvent } from "../../engine/2d/events/MouseEvent";
import { Panel } from "../../module/views/Panel";
import { RES } from "../../module/RES";
import { Sprite } from "../../engine/2d/display";
import { Graphics } from '../../engine/2d/graphics';
import { showPanel } from '../../module/ctrls';
import { TaskPanel } from './TaskPanel';


export class PropOutPanel extends Panel {
    get groupNames() { return ["propOutPanel"] }

    closeBtn: Button;
    getPropBtn: Button;
    initUi() {
        //背景
        this.addChild(Tool.addSprite("propOutPanelBg.png"));
        //关闭按钮
        this.closeBtn = new Button(RES.getRes("comCloseBtn.png"));
        this.closeBtn.position.set(627, 471);
        this.addChild(this.closeBtn);
        //获取道具按钮，弹出任务弹框
        this.getPropBtn = new Button(RES.getRes("getPropBtn.png"));
        this.getPropBtn.position.set(209, 749);
        this.addChild(this.getPropBtn);
    }

    start(data) {
        super.start();
    }

    initEvents() {
        this.onClick(this.closeBtn, this.onClick_closeBtn, this)
        this.onClick(this.getPropBtn, this.onClick_getPropBtn, this)
    }

    onClick_closeBtn() {
        this.hidePanel();
    }
    onClick_getPropBtn() {
        this.hidePanel();
        showPanel(TaskPanel)
    }
    removeEvents() {
        this.removeClick(this.closeBtn, this.onClick_closeBtn, this)
        this.removeClick(this.getPropBtn, this.onClick_getPropBtn, this)
    }

}