import { HashObject } from "../2d/HashObject";

/**
 * 3d点类，和监控点合并吧
 */
export class Point3d extends HashObject {
    private _x: number;
    private _y: number;
    private _z: number;
    private cb: Function;
    private scope: any
    get x(): number {
        return this._x
    }
    set x(value: number) {
        if (this._x !== value) {
            this._x = value;
            this.callChange();
        }
    }
    get y(): number {
        return this._y
    }
    set y(value: number) {
        if (this._y !== value) {
            this._y = value;
            this.callChange();
        }
    }
    get z(): number {
        return this._z
    }
    set z(value: number) {
        if (this._z !== value) {
            this._z = value;
            this.callChange();
        }
    }
    constructor(x: number = 0, y: number = 0, z: number = 0, cb?: Function, scope?: any) {
        super()
        this.x = x;
        this.y = y;
        this.z = z;
        this.cb = cb;
        this.scope = scope;
    }
    private callChange() {
        this.cb && this.cb.call(this.scope);
    }
    set(x: number = 0, y?: number, z?: number) {
        const _x = x || 0;
        const _y = (y === undefined) ? _x : (y || 0);
        const _z = (y === undefined) ? _x : (z || 0);
        if (this._x !== _x || this._y !== _y || this._z !== _z) {
            this._x = _x;
            this._y = _y;
            this._z = _z;
            this.callChange();
        }
        return this;
    }
    copy(p: Point3d) {
        if (this._x !== p.x || this._y !== p.y || this._z !== p.z) {
            this._x = p.x;
            this._y = p.y;
            this._z = p.z;
            this.callChange();
        }
        return this;
    }
    destroy() {
    }
}
