'use strict';

import React, { Component } from 'react';

import './profile.less';
class Profile extends Component {
    constructor(props) {
        super(props);
    }
    render () {
        return (
            <div className={`_profile ${this.props.className}`}>
                <div className="imgs">
                    {this.pic(this.props.srcs[0])}
                    {this.getRes()}
                </div>
                {this.props.hasText ? <span className="info">助力好友:{this.props.srcs.length - 1}</span> : ''}
            </div>
        );
    }

    getRes = () => {
        let array = []
        for (let i = 1; i < Math.min(this.props.srcs.length, 4); i++) {
            const e = this.props.srcs[i]
            array.push(this.pic(e, 1, (i - 1) * 25 + 50))
        }
        return array
    }

    pic = (src, width = 2, left) => {
        return (<div className={width == 1 ? 'sub' : 'main'} key={src.substr(0, 8) + left} style={{
            border: `${width}px solid white`,
            backgroundImage: `url(${src})`,
            left: `${left}%`,
        }} ></div>)
    }
}
export default Profile;