import React, { Component } from "react";
import ReactDOM from "react-dom";
import "./app.less";
import 'spark-design/dist/index.css'
import { MOCK_STATUS } from '../sparkrc';
MOCK_STATUS && (require('../mock/index'));
import MD from '../MD';
MD();
//此处为spark-cli动态生成
import resList from './resconfig/resList';
import Pagezu_dui_ye_cheng_wei_dui_chang from "./pages/Pagezu_dui_ye_cheng_wei_dui_chang/Pagezu_dui_ye_cheng_wei_dui_chang.jsx";
import Pageyao_qing_ru_dui_fen_xiang_luo from "./pages/Pageyao_qing_ru_dui_fen_xiang_luo/Pageyao_qing_ru_dui_fen_xiang_luo.jsx";
import Pagezhu_li_pkzhu_li_fen from "./pages/Pagezhu_li_pkzhu_li_fen/Pagezhu_li_pkzhu_li_fen.jsx";
import Dig from "./pages/dig/dig.jsx";
import API from './api';


import { getModalHoc } from "spark-design";
import Rule from "./components/comhuo_dong_gui_ze_dan_chuang/comhuo_dong_gui_ze_dan_chuang.jsx";
const RuleModal = getModalHoc(Rule);
import Prize from "./components/Comwo_de_jiang_pin_ye_mian/Comwo_de_jiang_pin_ye_mian.jsx";
const PrizeModal = getModalHoc(Prize);
import Full from "./components/Comman_yuan_dan_chuang/Comman_yuan_dan_chuang.jsx";
const FullModal = getModalHoc(Full);
import More from "./components/Comru_dui_dan_chuang_cheng_gong_ru/Comru_dui_dan_chuang_cheng_gong_ru.jsx";
const MoreModal = getModalHoc(More);
import GetBean from "./components/Comru_dui_dan_chuang_zu_dui_cheng/Comru_dui_dan_chuang_zu_dui_cheng.jsx";
const GetBeanModal = getModalHoc(GetBean);
import Gone from "./components/Comru_dui_dan_chuang_dui_wu_bu/Comru_dui_dan_chuang_dui_wu_bu.jsx";
const GoneModal = getModalHoc(Gone);
import Already from "./components/Comru_dui_dan_chuang_ben_ren_ru_12/Comru_dui_dan_chuang_ben_ren_ru_12.jsx";
const AlreadyModal = getModalHoc(Already);
import Self from "./components/Comru_dui_dan_chuang_ben_ren_ru_15/Comru_dui_dan_chuang_ben_ren_ru_15.jsx";
const SelfModal = getModalHoc(Self);
import Success from "./components/Comzhu_li_dan_chuang_zhu_li_cheng/Comzhu_li_dan_chuang_zhu_li_cheng.jsx";
const SuccessModal = getModalHoc(Success);
import Done from "./components/Comzhu_li_dan_chuang_chong_fu_zhu/Comzhu_li_dan_chuang_chong_fu_zhu.jsx";
const DoneModal = getModalHoc(Done);
import Self_ from "./components/Comzhu_li_dan_chuang_wei_zi_ji/Comzhu_li_dan_chuang_wei_zi_ji.jsx";
const Self_Modal = getModalHoc(Self_);
import End from "./components/Comzhu_li_dan_chuang_ben_chang_huo/Comzhu_li_dan_chuang_ben_chang_huo.jsx";
const EndModal = getModalHoc(End);

import Profile from './components/profile/profile.jsx'

const MODAL_MAP = {
  rule: RuleModal,
  prize: PrizeModal,

  full: FullModal,
  more: MoreModal,
  getBean: GetBeanModal,
  gone: GoneModal,
  already: AlreadyModal,
  self: SelfModal,

  success: SuccessModal,
  done: DoneModal,
  self_: Self_Modal,
  end: EndModal,
}
const DATA_MAP = {
  rule: '',
  prize: '',
}

// const shared = Math.random() * 2
const shared = 0

class App extends Component {
  constructor(props) {
    super(props)
    this.state = {
      modalState: '',
      resList: resList,
      // current: shared ? 'main' : 'sub',
      current: 'main',
    }
  }

  async componentDidMount () {
    let data = ''
    // data = await API.getRule()
    data = `await API.getRule()` + `活动规则`.repeat(Math.random() * 20)
    DATA_MAP.rule = data

    // data = await API.getHomeInfo()

    DATA_MAP.prize = [
      { name: '我的奖品', code: '奖品编码：20202', info: '该权益已过期，请联系客服', status: 'fetch', src: '' },
      { name: '我的品', code: '奖品编码：20202', info: '该过期，请联系客服', status: 'fail', src: '' },
      { name: '我的奖品', code: '奖品20202', info: '该权期，请联系客服', status: 'invalid', src: '' },
      { name: '我奖品', code: '奖品编码：20202', info: '该，请联系客服', status: 'fetch', src: '' },
      { name: '我奖品', code: '奖品编码：20202', info: '该，请联系客服', status: 'fetch', src: '' },
      { name: '我奖品', code: '奖品编码：20202', info: '该，请联系客服', status: 'fetch', src: '' },
      { name: '我奖品', code: '奖品编码：20202', info: '该，请联系客服', status: 'fetch', src: '' },
      { name: '我奖品', code: '奖品编码：20202', info: '该，请联系客服', status: 'fetch', src: '' },
      { name: '我奖品', code: '奖品编码：20202', info: '该，请联系客服', status: 'fetch', src: '' },
    ]

    console.log(data)
  }

  render () {
    return (
      <div>
        { this.switcher(this.state.current)}
        {this.state.modalState && (
          <section className="modal-bg">
            {this.getModal(this.state.modalState)}
          </section>
        )}
      </div >
    );
  }


  switcher = (url) => {
    switch (url) {
      case 'main':
        return <Pagezu_dui_ye_cheng_wei_dui_chang modal={this.openModal} go={this.go}></Pagezu_dui_ye_cheng_wei_dui_chang>
      case 'sub':
        return <Pageyao_qing_ru_dui_fen_xiang_luo modal={this.openModal} go={this.go}></Pageyao_qing_ru_dui_fen_xiang_luo>
      case 'dig':
        return <Dig modal={this.openModal} go={this.go}></Dig>
      case 'help':
        return <Pagezhu_li_pkzhu_li_fen modal={this.openModal} go={this.go}></Pagezhu_li_pkzhu_li_fen>
      default:
        break;
    }
  }

  go = (url) => {
    this.closeModal()
    console.log(url);
    this.setState({ current: url })
  }

  getModal = (str) => {
    const Modal = str ? MODAL_MAP[str] : null
    return <Modal closeModal={this.closeModal} data={DATA_MAP[str]} go={this.go}></Modal>
  }
  openModal = (str) => {
    this.setState({ modalState: str })
  }
  closeModal = () => {
    this.setState({ modalState: '' })
  }
}

ReactDOM.render(<App />, document.getElementById("root"));
