package indi.wuyue.elasticsearch.basic;

import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.mapping.PutMapping;
import org.elasticsearch.common.settings.Settings;

public class JestMigrateClient {

    private static final String mapping = "{\n" +
            "\t\"2018-07-30\": {\n" +
            "\t\t\"properties\": {\n" +
            "\t\t\t\"ae\": {\n" +
            "\t\t\t\t\"type\": \"keyword\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"consume_total\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"launch_pv\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"slot_source\": {\n" +
            "\t\t\t\t\"type\": \"keyword\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"app_name\": {\n" +
            "\t\t\t\t\"type\": \"keyword\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"ef_click_pv\": {\n" +
            "\t\t\t\t\"type\": \"double\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"cur_date\": {\n" +
            "\t\t\t\t\"type\": \"keyword\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"advert_name\": {\n" +
            "\t\t\t\t\"type\": \"keyword\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"slot_id\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"click_pv\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"exposure_pv\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"arpu\": {\n" +
            "\t\t\t\t\"type\": \"double\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"slot_name\": {\n" +
            "\t\t\t\t\"type\": \"keyword\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"app_id\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"coupon_type\": {\n" +
            "\t\t\t\t\"type\": \"keyword\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"advert_id\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"ef_click_piece\": {\n" +
            "\t\t\t\t\"type\": \"double\"\n" +
            "\t\t\t}\n" +
            "\t\t}\n" +
            "\t}\n" +
            "}";

    public static void main(String[] args) throws Exception {
        // Construct a new Jest client according to configuration via factory
        JestClientFactory factory = new JestClientFactory();
        factory.setHttpClientConfig(new HttpClientConfig
                .Builder("http://es-cn-4590plkku0004vufk.elasticsearch.aliyuncs.com:9200")
                .defaultCredentials("elastic", "1zO^U6!zPxHr9vex")
                .multiThreaded(true)
                .build());

        JestClient client = factory.getObject();

        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put("number_of_shards",5);
        settingsBuilder.put("number_of_replicas",1);

        client.execute(new CreateIndex.Builder("es_advert_slot_app_coupon_di")
                .settings(settingsBuilder.build().getAsMap()).build());

        PutMapping putMapping = new PutMapping.Builder(
                "es_advert_slot_app_coupon_di",
                "2018-07-30",
                mapping)
                .build();
        JestResult result = client.execute(putMapping);

        System.out.println("----------");

    }
}
