package indi.wuyue.elasticsearch.basic;

import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.mapping.PutMapping;
import org.elasticsearch.common.settings.Settings;

public class JestHiveMigrateClient2 {

    private static final String mapping = "{\n" +
            "  \"2018-07-30\": {\n" +
            "    \"properties\": {\n" +
            "      \"app_id\": {\n" +
            "        \"type\": \"long\"\n" +
            "      },\n" +
            "      \"app_name\": {\n" +
            "        \"type\": \"keyword\"\n" +
            "      }\n" +
            "    }\n" +
            "  }\n" +
            "}";

    public static void main(String[] args) throws Exception {
        // Construct a new Jest client according to configuration via factory
        JestClientFactory factory = new JestClientFactory();
        factory.setHttpClientConfig(new HttpClientConfig
                .Builder("http://es-cn-4590plkku0004vufk.elasticsearch.aliyuncs.com:9200")
                .defaultCredentials("elastic", "1zO^U6!zPxHr9vex")
                .multiThreaded(true)
                .build());

        JestClient client = factory.getObject();

        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put("number_of_shards",5);
        settingsBuilder.put("number_of_replicas",1);

        client.execute(new CreateIndex.Builder("es_tuia_app_di_test")
                .settings(settingsBuilder.build().getAsMap()).build());

        PutMapping putMapping = new PutMapping.Builder(
                "es_tuia_app_di_test",
                "2018-07-30",
                mapping)
                .build();
        JestResult result = client.execute(putMapping);

        System.out.println("----------");

    }
}
