package indi.wuyue.elasticsearch.service;

import io.searchbox.client.JestClient;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
public class JestService {

    @Resource
    private JestClient client;

    public List<String> test() throws Exception {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(QueryBuilders.matchQuery("app_id", "17775"));

        Search search = new Search.Builder(searchSourceBuilder.toString())
                // multiple index or types can be added.
                .addIndex("es_tuia_app_di_test")
                .addType("2018-07-30")
                .build();

        SearchResult result = client.execute(search);
        List<String> sourceList = result.getSourceAsStringList();
        return sourceList;
    }
}
