package indi.wuyue.elasticsearch.basic;

import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.mapping.PutMapping;
import org.elasticsearch.common.settings.Settings;

public class JestHiveMigrateClient {

    private static final String mapping = "{\n" +
            "\t\"2018-06-03\": {\n" +
            "\t\t\"properties\": {\n" +
            "\t\t\t\"act_request_count\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"advert_click_count\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"duration_type\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"participate_uv\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"finish_time\": {\n" +
            "\t\t\t\t\"type\": \"string\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"act_click_count\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"act_suc_response_count\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"act_click_uv\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"app_name\": {\n" +
            "\t\t\t\t\"type\": \"keyword\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"launch_count\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"start_time\": {\n" +
            "\t\t\t\t\"type\": \"keyword\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"cur_date\": {\n" +
            "\t\t\t\t\"type\": \"keyword\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"act_expose_count\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"act_request_uv\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"advert_request_count\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"sdk_uv\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"participate_count\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"duration_time\": {\n" +
            "\t\t\t\t\"type\": \"keyword\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"sdk_pv\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"advert_exposure_count\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"advert_fee\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t},\n" +
            "\t\t\t\"app_id\": {\n" +
            "\t\t\t\t\"type\": \"long\"\n" +
            "\t\t\t}\n" +
            "\t\t}\n" +
            "\t}\n" +
            "}";

    public static void main(String[] args) throws Exception {
        // Construct a new Jest client according to configuration via factory
        JestClientFactory factory = new JestClientFactory();
        factory.setHttpClientConfig(new HttpClientConfig
                .Builder("http://es-cn-4590plkku0004vufk.elasticsearch.aliyuncs.com:9200")
                .defaultCredentials("elastic", "1zO^U6!zPxHr9vex")
                .multiThreaded(true)
                .build());

        JestClient client = factory.getObject();

        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put("number_of_shards",5);
        settingsBuilder.put("number_of_replicas",1);

        client.execute(new CreateIndex.Builder("es_tuia_app_di")
                .settings(settingsBuilder.build().getAsMap()).build());

        PutMapping putMapping = new PutMapping.Builder(
                "es_tuia_app_di",
                "2018-07-30",
                mapping)
                .build();
        JestResult result = client.execute(putMapping);

        System.out.println("----------");

    }
}
