package indi.wuyue.elasticsearch.basic;

import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class JestClientSearchClient {

    public static void main(String[] args) throws Exception {

        // Construct a new Jest client according to configuration via factory
        JestClientFactory factory = new JestClientFactory();
        factory.setHttpClientConfig(new HttpClientConfig
                .Builder("http://es-cn-4590plkku0004vufk.elasticsearch.aliyuncs.com:9200")
                .defaultCredentials("elastic", "1zO^U6!zPxHr9vex")
                .multiThreaded(true)
                .build());

        JestClient client = factory.getObject();

        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(QueryBuilders.matchQuery("app_id", "17775"));

        Search search = new Search.Builder(searchSourceBuilder.toString())
                // multiple index or types can be added.
                .addIndex("es_tuia_app_di_test")
                .addType("2018-07-30")
                .build();

        SearchResult result = client.execute(search);
    }
}
