package indi.wuyue.elasticsearch.basic;

import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.xpack.client.PreBuiltXPackTransportClient;

import java.net.InetAddress;


public class ClientTest {

    public static void main(String[] args) throws Exception {
        Settings settings = Settings.builder()
                .put("xpack.security.transport.ssl.enabled", false)
                .put("xpack.security.user", "elastic:1zO^U6!zPxHr9vex")
                .put("client.transport.sniff", false).build();

        try (PreBuiltXPackTransportClient client = new PreBuiltXPackTransportClient(settings)) {
            client.addTransportAddress(new InetSocketTransportAddress(
                    InetAddress.getByName("es-cn-4590plkku0004vufk.elasticsearch.aliyuncs.com"), 9300));
            ClusterHealthResponse healths = client.admin().cluster().prepareHealth().get();
            System.out.println(healths.getClusterName());
        } finally {

        }

    }

//    public static void main(String[] args) throws Exception {
//
//        Settings settings = Settings.builder()
//                .put("xpack.security.user", "elastic:1zO^U6!zPxHr9vex")
//                .put("http.basic.user", "elastic")
//                .put("http.basic.password", "1zO^U6!zPxHr9vex")
//                .build();
//
//        TransportClient client = new PreBuiltTransportClient(settings)
//                .addTransportAddress(new InetSocketTransportAddress(
//                        InetAddress.getByName("es-cn-4590plkku0004vufk.elasticsearch.aliyuncs.com"), 9300));
//
//
//        CreateIndexResponse response = client.admin().indices().prepareCreate("bigdate")
//                .setSettings(Settings.builder()
//                        .put("index.number_of_shards", 3)
//                        .put("index.number_of_replicas", 2))
//                .addMapping("student1", "{\n" +
//                        "\t\"student1\": {\n" +
//                        "\t\t\"properties\": {\n" +
//                        "\t\t\t\"area\": {\n" +
//                        "\t\t    \t\"type\": \"long\"\n" +
//                        "\t\t    },\n" +
//                        "\t\t    \"recordtime\": {\n" +
//                        "\t\t    \t\"type\": \"long\"\n" +
//                        "\t\t    },\n" +
//                        "\t\t    \"count\": {\n" +
//                        "\t\t    \t\"type\": \"long\"\n" +
//                        "\t\t    },\n" +
//                        "\t\t    \"usertype\": {\n" +
//                        "\t\t    \t\"type\": \"long\"\n" +
//                        "\t\t    }\n" +
//                        "\t\t}\n" +
//                        "\t}\n" +
//                        "}").get();
//
//        // on shutdown
//        client.close();
//    }
}
